package org.esupportail.portal.channels.CIntranet.data;

import java.util.Collection;

import org.esupportail.portal.channels.CIntranet.beans.Intranet;
import org.esupportail.portal.utils.database.Query;

/**
 * IDataIntranet<br>
 * <br>
 * Cette interface dcrit les mthodes d'accs aux intranets<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */
public interface IDataIntranet {
    
    /**
	 * Rcupration d'un intranet
	 * @param query La connexion  utiliser
	 * @param id L'identifiant d'intranet
	 * @return L'intranet correspondant
	 * @throws DataException
	 */
	public Intranet getIntranet(Query query, String id) throws DataException;

	/**
	 * Rcupration de la liste de tous les intranets
	 * @param query La connexion  utiliser
	 * @return La liste de tous les intranets
	 * @throws DataException
	 */
	public Collection getIntranets(Query query) throws DataException;
	
	/**
	 * Cration d'un intranet
	 * @param query La connexion  utiliser
	 * @param intranet L'intranet  crer
	 */
	public void createIntranet(Query query, Intranet intranet) throws DataException;
	
	/**
	 * Suppression d'un intranet
	 * @param query La connexion  utiliser
	 * @param intranet L'intranet  supprimer
	 * @throws DataException
	 */
	public void removeIntranet(Query query, Intranet intranet) throws DataException;
	
	/**
	 * Test de l'existence d'un intranet
	 * @param query La connexion  utiliser
	 * @param intranet L'intranet dont on teste l'existence
	 * @return boolean true si l'intranet existe, false sinon
	 * @throws DataException
	 */
	public boolean intranetExist(Query query, Intranet intranet) throws DataException;
}
