package org.esupportail.portal.channels.CIntranet.data;

import java.util.Collection;

import org.esupportail.portal.channels.CIntranet.beans.Mime;
import org.esupportail.portal.utils.database.Query;

/**
 * IDataMIME<br>
 * <br>
 * Cette interface dcrit les mthodes d'accs aux types MIME<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */
public interface IDataMIME {

    /**
	 * Rcupration des types MIME valides
	 * @param query La connexion  utiliser
	 * @return La liste des types MIME
	 * @throws DataException
	 */
	public Collection getMIMEs(Query query) throws DataException;
	
	/**
	 * Cration d'un type MIME
	 * @param query La connexion  utiliser
	 * @param mime Le type MIME  crer
	 */
	public void createMIME(Query query, Mime mime) throws DataException;
	
	/**
	 * Suppression d'un type MIME
	 * @param query La connexion  utiliser
	 * @param extension L'extension associe au type MIME
	 * @throws DataException
	 */
	public void removeMIME(Query query, String extension) throws DataException;
	
	/**
	 * Vrifie la validit d'un type MIME
	 * @param query La connexion  utiliser
	 * @param extension L'extension  tester
	 * @return boolean True si le type est valide, false sinon
	 * @throws DataException
	 */
	public boolean isValidMIME(Query query, String extension) throws DataException;
}
