package org.esupportail.portal.channels.CIntranet.data;

import java.util.Collection;

import org.esupportail.portal.utils.database.Query;

/**
 * IDataValidator<br>
 * <br>
 * Cette interface dcrit les mthodes d'accs aux valideurs<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */
public interface IDataValidator {

    /**
	 * Rcupration des valideurs d'un dossier
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @return La liste des valideurs
	 * @throws DataException
	 */
	public Collection getValidators(Query query, String id) throws DataException;
	
	/**
	 * Ajout d'un valideur
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @param login L'identifiant de l'utilisateur
	 */
	public void addValidator(Query query, String id, String login) throws DataException;
	
	/**
	 * Ajout d'une liste de valideurs
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @param logins La liste des logins
	 */
	public void addValidator(Query query, String id, Collection logins) throws DataException;
	
	/**
	 * Suppression d'un valideur
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @param login L'identifiant de l'utilisateur
	 * @throws DataException
	 */
	public void removeValidator(Query query, String id, String login) throws DataException;
	
	/**
	 * Suppression de tous les valideurs d'un dossier
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @throws DataException
	 */
	public void removeAllValidators(Query query, String id) throws DataException;
}
