package org.esupportail.portal.channels.CIntranet.security;

/**
 * ISecurityManager<br>
 * <br>
 * Interface dcrivant les mthodes que doit obligatoirement implmenter<br>
 * le gestionnaire de scurit<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 1.1
 * 
 */

public interface ISecurityManager {
	
	public static final int VALIDATOR = 100;
	public static final int PUBLICATOR = 50;
	public static final int USER = 1;
	
	/**
	 * Si l'utilisateur est un super-utilisateur
	 * @param login Le login de l'utilisateur
	 * @return true si c'est un super-utilisateur, false sinon
	 * @throws SecurityException
	 */
	public boolean isSuperUser(String login) throws SecurityException;
	
	/**
	 * Si l'utilisateur fait partie de la population d'un intranet
	 * @param intranet L'identifiant de l'intranet
	 * @param login L'identifiant de l'utilisateur
	 * @return true si l'utilisateur fait partie de la population, false sinon
	 * @throws SecurityException
	 */
	public boolean isIntranetAccessible(String intranet, String login) throws SecurityException;
	
	/**
	 * Retourne une constante indiquant le statut d'un utilisateur pour un dossier donn
	 * @param folder L'identifiant du dossier
	 * @param login L'identifiant de l'utilisateur
	 * @return USER si c'est un utilisateur standard<br>
	 * PUBLICATOR si c'est un publicateur
	 * VALIDATOR si c'est un valideur
	 * @throws SecurityException
	 */
	public int getRoleOfUser(String folder, String login) throws SecurityException;
}
