<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:import href="./ViewFolder_templates.xsl" />

<xsl:output method="html" indent="no" />

<xsl:param name="baseActionURL" />
<xsl:param name="baseDownloadURL" />
<xsl:param name="prefForm" />
<xsl:param name="mediaPath" />

<xsl:template match="folder">

<script language="javascript" src="{$mediaPath}functions.js" >
</script>
	
	<table width="100%" border="0" cellspacing="0" cellpadding="5">
		<tr class="uportal-background-light">
			
			<xsl:call-template name="outil.actualiser"/>
			<xsl:call-template name="outil.intranets"/>
			
			<td width="100%">&#160;</td>
		</tr>
	</table>
		
	<br/>
	
	<!-- Affichage chemin courant -->
	<table border="0" width="100%">
		<tr>
			<xsl:apply-templates select="path/subfolder" />
			<td width="100%">&#160;</td>
		</tr>
	</table>
	
	<!-- Affichage des sous-dossiers -->		
	<xsl:apply-templates select="subfolders" />
	
	<!-- Affichage des documents -->
	<xsl:apply-templates select="documents" />

</xsl:template>

<!-- Affichage des documents -->
<xsl:template match="documents">
	
	<xsl:if test="count(document)!=0">
		<br/>
			<!-- Pas de formulaire -->
			<table border="0" width="100%" cellpadding="1" cellspacing="0">
				<!-- Affichage des documents -->
				<xsl:apply-templates select="document">
					<xsl:sort select="@order" data-type="number" order="ascending" />
				</xsl:apply-templates>
			</table>	
	</xsl:if>
	
</xsl:template>

<!-- Affichage des options de document -->
<xsl:template match="document">
	
	<xsl:call-template name="user" />

</xsl:template>


<!-- Aucun droit -->
<xsl:template name="user">
	<tr onmouseover="setPointer(this, 'over', 'uportal-background-light', 'BODY');" onmouseout="setPointer(this, 'out', 'uportal-background-light', 'BODY');">	
		<xsl:call-template name="icon.nocheckbox" />
		<xsl:call-template name="icon.zoom" />
		<xsl:call-template name="icon.nomodify" />
		<xsl:call-template name="icon.nodelete" />
		<xsl:call-template name="icon.noup" />
		<xsl:call-template name="icon.nodown" />
		
		<td width="5%">&#160;</td>
		
		<xsl:choose>
			<xsl:when test="./@type='file'">
				<xsl:call-template name="document.fichier" />
			</xsl:when>
			<xsl:when test="./@type='link'">
				<xsl:call-template name="document.lien" />
			</xsl:when>
		</xsl:choose>
		
		<td width="100%">&#160;</td>
	</tr>
</xsl:template>
			
</xsl:stylesheet>