package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.Hashtable;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.beans.Folder;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataControler;
import org.esupportail.portal.channels.CIntranet.security.ISecurityManager;
import org.esupportail.portal.channels.CIntranet.storage.IStorageControler;
import org.esupportail.portal.channels.CIntranet.storage.StorageException;
import org.esupportail.portal.channels.CIntranet.storage.StorageFactory;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * DeleteDocuments<br>
 * <br>
 * Cette action prend en charge la suppression de plusieurs documents<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */

public class DeleteDocuments extends IntranetAction {

    protected static final Log log = LogFactory.getLog(DeleteDocuments.class);
    
    String [] ids = null;
	
	/**
	 * Constructeur
	 * @param mainChannel Channel principale
	 */
	public DeleteDocuments(MainChannel mainChannel) {
		super(mainChannel);
	}
	
	/**
	 * Retourne le niveau d'accrditation minimum pour accder  cette action
	 * @return ISecurityManager.PUBLICATOR
	 */
	public int getLevel() {
		return ISecurityManager.PUBLICATOR;
	}
	
	/**
	 * Mthode appele si la personne a le niveau requis
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon 
	 */
	public Boolean action() throws PortalException, FrameWorkException {
		if(log.isDebugEnabled()) {
		    log.debug("DeleteDocuments::action()");
		}
		
		// Rcupration paramtres
		ids = runtimeData.getParameterValues("id");
		
		// Vrification validit des paramtres
		if(ids == null) {
			// Aucun document slectionn
			// Redirection affichage du dossier
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "viewfolder");
			return Boolean.FALSE;
		}
		
		// Rcupration IDataReadManager
		IDataControler data = DataFactory.make();
		
		Folder dossier = null;
		// Rcupration du dossier
		try {
			dossier = data.getFolder(folderid, false);
		}
		catch(DataException e) {
			log.error("DeleteDocuments::action() : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur lors de la suppression des documents"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Vrification accs
		if(!superuser && role == ISecurityManager.PUBLICATOR && dossier.isValidation()) {
			log.error("DeleteDocuments::action() : Accs non autoris");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		return Boolean.TRUE;
	}

	/**
	 * Affichage de la confirmation de suppression
	 * @return Boolean.TRUE 
	 */
	public Boolean setXML() throws FrameWorkException {
		// Affichage confirmation
		this.xml = "";
		return Boolean.TRUE;
	}

	/**
	 * Effectue les suppressions
	 * @param rd
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon 
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean delinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		runtimeData = rd;
		if(log.isDebugEnabled()) {
		    log.debug("DeleteDocuments::delinit()");
		}
		
		// Rcupration bouton
		String button = runtimeData.getParameter("butoui");
		
		// Bouton choisi
		if(button == null) {
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "viewfolder");
			return Boolean.FALSE;
		}
		
		// Rcupration IDataControler, IDataReadManager
		IDataControler data = DataFactory.make();
				
		// Rcupration IStorageControler
		IStorageControler store = StorageFactory.make(ressource);
		
		Vector v = new Vector();
		Document doc = null;
		for(int i=0;i<ids.length;i++) {
			String id = ids[i];
			try {
				doc = data.getDocument(intranet, id);
				
				data.removeDocument(doc);
				if(doc.getType() == Document.FILE) {
					store.destroyDocument(intranet, doc);
				}
				data.commit();
				v.add(new MessageBean(doc.getName() + " : Document supprim\u00E9", Message.INFO));
			}
			catch(DataException e) {
				log.error("DeleteDocuments::delinit() : " + e);
				v.add(new MessageBean(doc.getName() + " : " + e.getMessage(), Message.ERROR));
			}
			catch(StorageException e) {
				log.error("DeleteDocuments::delinit() : " + e);
				data.rollback();
				v.add(new MessageBean(doc.getName() + " : Document supprim\u00E9", Message.INFO));
			}
		}
		Hashtable parameters = new Hashtable();
		parameters.put("folderid", folderid);
		Message.message(mainChannel, runtimeData, v, "viewfolder", parameters);
		return Boolean.FALSE;
	}
}