package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.Hashtable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Folder;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataControler;
import org.esupportail.portal.channels.CIntranet.security.ISecurityManager;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * ModifyFolder<br>
 * <br>
 * Cette action prend en charge la modification d'un dossier<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */

public class ModifyFolder extends IntranetAction {

    protected static final Log log = LogFactory.getLog(ModifyFolder.class);
    
    private Folder dossier = null;

	/**
	 * Constructeur
	 * @param mainChannel Channel principale
	 */
	public ModifyFolder(MainChannel mainChannel) {
		super(mainChannel);
	}
	
	/**
	 * Retourne le niveau d'accrditation minimum pour accder  cette action
	 * @return ISecurityManager.VALIDATOR
	 */
	public int getLevel() {
		return ISecurityManager.VALIDATOR;
	}

	/**
	 * Mthode appele si la personne a le niveau requis
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon 
	 */
	public Boolean action() throws PortalException, FrameWorkException {
		if(log.isDebugEnabled()) {
		    log.debug("ModifyFolder::action()");
		}
		
		// Rcupration IDataControler
		IDataControler data = DataFactory.make();
		
		// Rcupration dossier
		try {
			dossier = data.getFolder(folderid, false);
		}
		catch(DataException e) {
			log.error("ModifyFolder::action() : DatabaseException : " + e);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");
			return Boolean.FALSE;
		}
		
		// Vrification racine
		if(dossier.isRoot()) {
			log.error("ModifyFolder::action() : Modification du dossier racine");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Impossible de modifier le dossier racine"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		return Boolean.TRUE;
	}
	
	/**
	 * Affiche le formulaire de modification de dossier
	 * @return Boolean.TRUE
	 */
	public Boolean setXML() {
		xml = dossier.toXMLString();
		return Boolean.TRUE;
	}
	
	/**
	 * Modification du dossier
	 * @param rd
	 * @return Boolean.FALSE (pas d'affichage)
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean modifyinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		if(log.isDebugEnabled()) {
		    log.debug("ModifyFolder::modifyinit()");
		}
		runtimeData = rd;
		
		// Vrification accs
		if(!superuser && role < getLevel()) {
			log.error("ModifyFolder::modifyinit() : Acc\u00E8s non autoris\u00E9");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00e9ration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration bouton
		String button = runtimeData.getParameter("butvalid");
	
		// Clic sur le bouton Annuler
		if(button == null) {
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "viewfolder");
			return Boolean.FALSE;
		}
		
		// Rcupration paramtres
		String name = runtimeData.getParameter("name");
		String validation = runtimeData.getParameter("valid");
		
		// Tentative d'accs sans paramtres
		if(name == null || name.equals("")) {
			log.error("ModifyFolder::modifyinit() : Erreur d'acc\u00E8s \u00E0 la page");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "default");		
			return Boolean.FALSE;
		}
		
		boolean valid = false;
		if(validation != null) {
			valid = true;
		}
		
		// Test si modifications
		if(valid == dossier.isValidation() && name.equals(dossier.getName())) {
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "viewfolder");
			return Boolean.FALSE;
		}
		
		// Rcupration IDataControler
		IDataControler data = DataFactory.make();
		
		// Modification de la validation
		if(valid != dossier.isValidation()) {
			try {
			    data.setValidation(dossier, valid);
			}
			catch(DataException e) {
			    log.error("ModifyFolder::modifyinit() : " + e);
				Hashtable parameters = new Hashtable();
				parameters.put("folderid", folderid);
				Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "viewfolder", parameters);
				return Boolean.FALSE;
			}
		}
		
		// Modification du nom
		if(!name.equals(dossier.getName())) {
			dossier.setName(name);
			try {
			    data.setName(dossier);
			}
			catch(DataException e) {
			    log.error("ModifyFolder::modifyinit() : " + e);
				Hashtable parameters = new Hashtable();
				parameters.put("folderid", folderid);
				Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "viewfolder", parameters);
				return Boolean.FALSE;
			}
		}
		
		runtimeData.setParameter("folderid", folderid);
		mainChannel.redirect(runtimeData, "viewfolder");
		return Boolean.FALSE;
	}
}
