package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.Hashtable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataControler;
import org.esupportail.portal.channels.CIntranet.security.ISecurityManager;
import org.esupportail.portal.channels.CIntranet.storage.IStorageControler;
import org.esupportail.portal.channels.CIntranet.storage.StorageException;
import org.esupportail.portal.channels.CIntranet.storage.StorageFactory;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.PortalException;

/**
 * ValidateDocument<br>
 * <br>
 * Cette action prend en charge la validation d'un document<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */

public class ValidateDocument extends IntranetAction {

    protected static final Log log = LogFactory.getLog(ValidateDocument.class);
    
    /**
	 * Constructeur
	 * @param mainChannel Channel principale
	 */
	public ValidateDocument(MainChannel mainChannel) {
		super(mainChannel);
	}

	/**
	 * Retourne le niveau d'accrditation minimum pour accder  cette action
	 * @return ISecurityManager.VALIDATOR
	 */
	public int getLevel() {
		return ISecurityManager.VALIDATOR;
	}
	
	/**
	 * Mthode appele si la personne a le niveau requis
	 * @return Boolean.FALSE (pas d'affichage)
	 */
	public Boolean action() throws PortalException, FrameWorkException {
		if(log.isDebugEnabled()) {
		    log.debug("ValidateDocument::action()");
		}
		
		// Rcupration des paramtres
		String id = runtimeData.getParameter("id");
		
		// Tentative d'accs sans paramtre
		if(id == null) {
			log.error("ValidateDocument::action() : Erreur d'acc\u00E8s \u00E0 la page");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "default");
			return Boolean.FALSE;
		}
		
		// Rcupration IDataControler
		IDataControler data = DataFactory.make();
		
		// Rcupration du document
		Document doc = null;
		try {
			doc = data.getDocument(intranet, id);
		}
		catch(DataException e) {
			log.error("ValidateDocument::action() : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Document introuvable"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration IStorageControler
		IStorageControler store = StorageFactory.make(ressource);
		
		// Validation du document
		doc.setId("v" + doc.getId().substring(1));
		try {
			data.validDocument(doc);
			if(doc.getType() == Document.FILE) {
			    store.validDocument(intranet, doc);
			}
			data.commit();
		}
		catch(DataException e) {
			log.error("ValidateDocument::action() : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			parameters.put("id", id);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "viewdoc", parameters);
			return Boolean.FALSE;
		}
		catch(StorageException e) {
			log.error("ValidateDocument::action() : " + e);
			data.rollback();
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			parameters.put("id", doc.getId());
			Message.message(mainChannel, runtimeData, new MessageBean("Le document a \u00E9t\u00E9 partiellement valid\u00E9, contactez votre administrateur syst\u00E8me pour plus d'informations"), "viewdoc", parameters);
			return Boolean.FALSE;
		}
		
		runtimeData.setParameter("folderid", folderid);
		runtimeData.setParameter("id", doc.getId());
		mainChannel.redirect(runtimeData, "viewdoc");
		return Boolean.FALSE;
	}
}
