package org.esupportail.portal.channels.CIntranet.actions.intranet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.FolderTree;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataControler;
import org.esupportail.portal.channels.CIntranet.security.ISecurityManager;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.PortalException;

/**
 * ViewTree<br>
 * <br>
 * Description<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */
public class ViewTree extends IntranetAction {

    protected static final Log log = LogFactory.getLog(ViewTree.class);
    
    private FolderTree tree = null;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public ViewTree(MainChannel mainChannel) {
        super(mainChannel);
    }
    
    /**
	 * Retourne le niveau d'accrditation minimum pour accder  cette action
	 * @return ISecurityManager.USER
	 */
    public int getLevel() {
        return ISecurityManager.USER;
    }
    
    /**
	 * Mthode appele si la personne a le niveau requis
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon 
	 */
    public Boolean action() throws PortalException, FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("ViewTree::action()");
        }
		
		// Rcupration IDataControler
		IDataControler data = DataFactory.make();
		
		// Rcupration Dossier
		try {
			tree = data.getFolderTree(folderid);
		}
		catch(DataException e) {
			log.error("ViewTree::action() : DatabaseException : " + e);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");
			return Boolean.FALSE;
		}
		return Boolean.TRUE;
    }
    
    /**
	 * Affichage de l'arbre
	 * @return Boolean.TRUE
	 */
	public Boolean setXML() {
		this.xml = tree.toXMLString();
		return Boolean.TRUE;
	}
}
