package org.esupportail.portal.channels.CIntranet.beans;

import java.util.Collection;
import java.util.Iterator;

/**
 * Folder<br>
 * <br>
 * Cette classe permet de manipuler les informations relatives  un dossier<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */

public class Folder extends SubFolder {

	private boolean validation = false;
	private Collection subFolders = null;
	private Collection documents = null;
	private Path path = null;
	private boolean root = false;
	
	/**
	 * Constructeur
	 */
	public Folder() {
	}

	/**
	 * Si ce dossier est soumis  validation
	 * @return
	 */
	public boolean isValidation() {
		return validation;
	}

	/**
	 * Dossier est soumis  validation
	 * @param validation
	 */
	public void setValidation(boolean validation) {
		this.validation = validation;
	}

	
	/**
	 * L'identifiant du dossier parent
	 * @param parent
	 */
	public void setParent(String parent) {
		this.parent = parent;
	    if(parent.equals("0")) {
		    setRoot(true);
		}
		else {
			setRoot(false);
		}
	}

	/**
	 * La liste des sous dossiers
	 * @return
	 */
	public Collection getSubFolders() {
		if (subFolders != null) {
			return subFolders;
		}
		return null;
	}

	/**
	 * La liste des sous dossiers
	 * @param subFolders
	 */
	public void setSubFolders(Collection subFolders) {
		this.subFolders = subFolders;
	}


	/**
	 * La liste des documents
	 * @return
	 */
	public Collection getDocuments() {
		if (documents != null) {
			return documents;
		}
		return null;
	}

	/**
	 * La liste des documents
	 * @param documents
	 */
	public void setDocuments(Collection documents) {
		this.documents = documents;
	}

	/**
	 * Le chemin du dossier
	 * @return
	 */
	public Path getPath() {
		return path;
	}

	/**
	 * Le chemin du dossier
	 * @param path
	 */
	public void setPath(Path path) {
		this.path = path;
	}


	/**
	 * Si ce dossier est la racine
	 * @return
	 */
	public boolean isRoot() {
		return root;
	}

	/**
	 * Racine du dossier
	 * @param root
	 */
	public void setRoot(boolean root) {
		this.root = root;
	}

	
	/**
	 * La reprsentation XML de ce dossier
	 * @return
	 */
	public String toXMLString() {
		StringBuffer xml = new StringBuffer();
		xml.append("<folder ");
		xml.append("id=\"" + getId() + "\" ");
		xml.append("intranet=\"" + getIntranet() + "\" ");
		xml.append("name=\"" + getName() + "\" ");
		xml.append("parentid=\"" + getParent() + "\" ");
		xml.append("validation=\"" + isValidation() + "\" >");
		
		if(path != null) {
			xml.append(getPath().toXMLString());
		}
		if(subFolders != null) {
		    xml.append("<subfolders>\n");		
		    Iterator i = getSubFolders().iterator();
		    if(i != null) {
		        while(i.hasNext()) {
		            SubFolder tmp = (SubFolder)i.next();
		            xml.append(tmp.toXMLString());
		        }
		    }
		    xml.append("</subfolders>\n");
		}
		
		if(documents != null) {
		    xml.append("<documents>\n");
		    Iterator i = getDocuments().iterator();
		    if(i != null) {
		        while(i.hasNext()) {
		            Document tmp = (Document)i.next();
		            xml.append(tmp.toXMLString());
		        }
		    }
		    xml.append("</documents>\n");
		}
		
		xml.append("</folder>\n");
		return xml.toString();
	}
}
