package org.esupportail.portal.channels.CIntranet.beans;

/**
 * SubFolder<br>
 * <br>
 * Cette classe permet de manipuler les informations relatives  un dossier<br>
 * en faisant abstraction des rpertoires et des documents qu'il contient et de son chemin<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */

public class SubFolder {

	private String id = null;
	private String name = null;
	private String intranet = null;
	protected String parent = null;
	
	/**
	 * Constructeur
	 */
	public SubFolder() {
		super();
	}

	/**
	 * L'identifiant de ce dossier
	 * @return
	 */
	public String getId() {
		return id;
	}

	/**
	 * L'identifiant de ce dossier
	 * @param id
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * Le nom de ce dossier
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * Le nom de ce dossier
	 * @param name
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * L'intranet de ce dossier
	 * @return
	 */
	public String getIntranet() {
		return intranet;
	}

	/**
	 * L'intranet de ce dossier
	 * @param intranet
	 */
	public void setIntranet(String intranet) {
		this.intranet = intranet;
	}

	/**
	 * Le dossier parent
	 * @return
	 */
	public String getParent() {
		return parent;
	}

	/**
	 * Le dossier parent
	 * @param parent
	 */
	public void setParent(String parent) {
		this.parent = parent;
	}

	/**
	 * La reprsentation XML de ce dossier
	 * @return
	 */
	public String toXMLString() {
		StringBuffer xml = new StringBuffer();
		xml.append("<subfolder ");
		xml.append("id=\"" + getId() + "\" ");
		xml.append("name=\"" + getName() + "\" ");
		xml.append("intranet=\"" + getIntranet() + "\" ");
		xml.append("parentid=\"" + getParent() + "\" ");
		xml.append("/>\n");
		return xml.toString();
	}
}