package org.esupportail.portal.channels.CIntranet.beans;

/**
 * User<br>
 * <br>
 * Cette classe permet de manipuler les informations relatives  un utilisateur<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */
public class User {

    private String login = null;
    private String displayName = null;
    
    /**
     * Constructeur
     */
    public User() {
    }
    
    /**
     * Le login
     * @param login
     */
    public void setLogin(String login) {
        this.login = login;
    }
    
    /**
     * Le login
     * @return
     */
    public String getLogin() {
        return login;
    }
    
    /**
     * Le nom courant
     * @param displayName
     */
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }
    
    /**
     * Le nom courant
     * @return
     */
    public String getDisplayName() {
        return displayName;
    }
    
    /**
     * Teste si deux utilisateurs sont identiques
     * @param o L'utilisateur  comparer
     * @return boolean true si les login sont les mmes, false sinon
     */
    public boolean equals(Object o) {
        if(o instanceof User) {
            User u = (User)o;
            return u.getLogin().equals(getLogin());
        }
        else {
            return false;
        }
    }
    
    /**
     * La reprsentation XML de cet utilisateur
     * @return Le flux XML
     */
    public String toXMLString() {
        StringBuffer xml = new StringBuffer();
        xml.append("<user login=\"" + getLogin() + "\" \n");
        xml.append("displayname=\"" + getDisplayName() + "\" />\n");
        return xml.toString();
    }
}
