package org.esupportail.portal.channels.CIntranet.config;

import java.util.Hashtable;

import org.esupportail.portal.channels.CIntranet.beans.Ressource;

/**
 * IntranetConfig<br>
 * <br>
 * Interface dcrivant quelles doivent tre les mthodes  implmenter par la classe<br>
 * s'occupant de la configuration de l'application spcifiques au canal Intranet<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 */


public interface IntranetConfig {

	/**
	 * La classe d'implmentation du IDataControler
	 * @return
	 */
	public String getDataControler();

	/**
	 * La classe d'implmentation du IDataControler
	 * @param classname
	 */
	public void setDataControler(String classname);
	
	/**
	 * La classe d'implmentation du IDataDocument
	 * @return
	 */
	public String getDataDocument();

	/**
	 * La classe d'implmentation du IDataDocument
	 * @param classname
	 */
	public void setDataDocument(String classname);
	
	/**
	 * La classe d'implmentation du IDataFolder
	 * @return
	 */
	public String getDataFolder();

	/**
	 * La classe d'implmentation du IDataFolder
	 * @param classname
	 */
	public void setDataFolder(String classname);
	
	/**
	 * La classe d'implmentation du IDataIntranet
	 * @return
	 */
	public String getDataIntranet();

	/**
	 * La classe d'implmentation du IDataIntranet
	 * @param classname
	 */
	public void setDataIntranet(String classname);
	
	/**
	 * La classe d'implmentation du IDataMIME
	 * @return
	 */
	public String getDataMIME();

	/**
	 * La classe d'implmentation du IDataMIME
	 * @param classname
	 */
	public void setDataMIME(String classname);
	
	/**
	 * La classe d'implmentation du IDataOrder
	 * @return
	 */
	public String getDataOrder();

	/**
	 * La classe d'implmentation du IDataOrder
	 * @param classname
	 */
	public void setDataOrder(String classname);
	
	/**
	 * La classe d'implmentation du IDataPopulation
	 * @return
	 */
	public String getDataPopulation();

	/**
	 * La classe d'implmentation du IDataPopulation
	 * @param classname
	 */
	public void setDataPopulation(String classname);
	
	/**
	 * La classe d'implmentation du IDataPublicator
	 * @return
	 */
	public String getDataPublicator();

	/**
	 * La classe d'implmentation du IDataPublicator
	 * @param classname
	 */
	public void setDataPublicator(String classname);
	
	/**
	 * La classe d'implmentation du IDataSU
	 * @return
	 */
	public String getDataSU();

	/**
	 * La classe d'implmentation du IDataSU
	 * @param classname
	 */
	public void setDataSU(String classname);
	
	/**
	 * La classe d'implmentation du IDataValidator
	 * @return
	 */
	public String getDataValidator();

	/**
	 * La classe d'implmentation du IDataValidator
	 * @param classname
	 */
	public void setDataValidator(String classname);

	/**
	 * La classe d'implmentation du ISecurityManager
	 * @return
	 */
	public String getSecurityManager();

	/**
	 * La classe d'implmentation du ISecurityManager
	 * @param classname
	 */
	public void setSecurityManager(String classname);

	/**
	 * La classe d'implmentation du IGroupManager
	 * @return
	 */
	public String getGroupManager();

	/**
	 * La classe d'implmentation du IGroupManager
	 * @param classname
	 */
	public void setGroupManager(String classname);

	/**
	 * La liste des ressources physiques de stockage
	 * @return
	 */
	public Hashtable getRessources();

	/**
	 * Ajout d'une ressource physique de stockage
	 * @param res
	 */
	public void addRessource(Ressource res);
	
	/**
	 * La liste des annuaires  utiliser
	 * @return
	 */
	public String getAnnuaires();
	
	/**
	 * La liste des annuaires  utiliser
	 * @param liste
	 */
	public void setAnnuaires(String liste);
}
