package org.esupportail.portal.channels.CIntranet.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.RDBMServices;

/**
 * DataDocument<br>
 * <br>
 * Classe d'accs aux donnes manipulant les documents<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */
public class DataDocument implements IDataDocument {
    
    protected static final Log log = LogFactory.getLog(DataDocument.class);

    /**
	 * Rcupration d'un document
	 * @param query La connexion  utiliser
	 * @param intranet L'identifiant de l'intranet auquel appartient le document
	 * @param id L'identifiant du dossier auquel appartient le document
	 * @return Le document
	 * @throws DataException
	 */
    public Document getDocument(Query query, String intranet, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataDocument::getDocument()");
        }
		Document res = new Document();
		
		String sql = "SELECT * FROM INT_DOCUMENT WHERE ID_DOC = '" + id + "' AND ID_INT = '" + intranet + "'";
		
		try {
			query.setSql(sql);
			query.select();
			ResultSet result = query.getRs();
			if(!result.next()) {
			    if(log.isDebugEnabled()) {
		            log.debug("DataDocument::getDocument() : Aucun document ayant pour ID = " + id);
			    }
				throw new DataException("Impossible d'acc\u00E9der \u00E0 ce document");
			}
			res.setId(id);
			res.setIntranet(intranet);
			res.setFolder(result.getString("ID_DOS"));
			if(result.getString("TYPE_DOC").equals("F")) {
				res.setType(Document.FILE);
			}
			else {
				res.setType(Document.LINK);
			}
			res.setName(result.getString("NOM_DOC"));
			res.setFile(result.getString("FILE_DOC"));
			res.setDescription(result.getString("DES_DOC"));
			res.setAuthor(result.getString("AUT_DOC"));
			res.setModificationDate(result.getString("DATE_DOC"));
			res.setLimitDate(result.getString("LIMIT_DOC"));
			
			if(result.getString("LOCK_DOC").equals("1")) {
				res.setLocked(true);
			}
			else {
				res.setLocked(false);
			}
			if(result.getString("NEW_DOC").equals("1")) {
				res.setNew(true);
			}
			else {
				res.setNew(false);
			}
			res.setOrder(result.getString("ORDER_DOC"));
		}
		catch(SQLException e) {
			log.error("DataDocument::getDocument() : " + e);
			log.error("DataDocument::getDocument() : SQL : " + sql);
			throw new DataException("Erreur lors de la lecture du document");
		}
		return res;
    }

    /**
	 * Rcupration des documents d'un dossier
	 * @param query La connexion  utiliser
	 * @param id L'identiant du dossier
	 * @return La liste des documents
	 * @throws DataException
	 */
    public Collection getDocuments(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataDocument::getDocuments()");
        }
		Collection res = new Vector();
		
		String sql = "SELECT * FROM INT_DOCUMENT WHERE ID_DOS = '" + id + "'";
		
		try {
			query.setSql(sql);
			query.select();
			ResultSet result = query.getRs();
			while(result.next()) {
				Document tmp = new Document();
				tmp.setId(result.getString("ID_DOC"));
				tmp.setIntranet(result.getString("ID_INT"));
				tmp.setFolder(id);
				if(result.getString("TYPE_DOC").equals("F")) {
					tmp.setType(Document.FILE);
				}
				else {
					tmp.setType(Document.LINK);
				}
				tmp.setName(result.getString("NOM_DOC"));
				tmp.setFile(result.getString("FILE_DOC"));
				tmp.setDescription(result.getString("DES_DOC"));
				tmp.setAuthor(result.getString("AUT_DOC"));
				tmp.setModificationDate(result.getString("DATE_DOC"));
				tmp.setLimitDate(result.getString("LIMIT_DOC"));
				if(result.getString("LOCK_DOC").equals("1")) {
					tmp.setLocked(true);
				}
				else {
					tmp.setLocked(false);
				}
				if(result.getString("NEW_DOC").equals("1")) {
					tmp.setNew(true);
				}
				else {
					tmp.setNew(false);
				}
				tmp.setOrder(result.getString("ORDER_DOC"));
				res.add(tmp);
			}
		}
		catch(SQLException e) {
		    log.error("DataDocument::getDocuments() : " + e);
		    log.error("DataDocument::getDocuments() : SQL : " + sql);
			throw new DataException("Erreur lors de la lecture des documents");
		}
		return res;
    }

    /**
	 * Cration d'un document
	 * @param query La connexion  utiliser
	 * @param doc Le document  crer
	 */
    public void createDocument(Query query, Document doc) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataDocument::createDocument()");
        }
        
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO INT_DOCUMENT(ID_DOC, ID_INT, ID_DOS, NOM_DOC, DES_DOC, TYPE_DOC, FILE_DOC, AUT_DOC, DATE_DOC, LIMIT_DOC, LOCK_DOC, EXT_DOC, NEW_DOC, ORDER_DOC) VALUES(");
        sql.append("'" + doc.getId() + "', ");
        sql.append("'" + doc.getIntranet() + "', ");
        sql.append(doc.getFolder() + ", ");
        sql.append("'" + RDBMServices.sqlEscape(doc.getName()) + "', ");
        sql.append("'" + RDBMServices.sqlEscape(doc.getDescription()) + "', ");
        if(doc.getType() == Document.FILE) {
            sql.append("'F', ");
        }
        else {
            sql.append("'L', ");
        }
        sql.append("'" + RDBMServices.sqlEscape(doc.getFile()) + "', ");
        sql.append("'" + doc.getAuthor() + "', ");
        sql.append("'" + doc.getModificationDate() + "', ");
        sql.append("'" + doc.getLimitDate() + "', ");
        if(doc.isLocked()) {
            sql.append("'1', ");
        }
        else {
            sql.append("'0', ");
        }
        sql.append("'" + doc.getExtension() + "', ");
        if(doc.isNew()) {
            sql.append("'1', ");
        }
        else {
            sql.append("'0', ");
        }
        sql.append(doc.getOrder() + ")");

        try {
            query.setSql(sql.toString());
            query.insert();
        }
        catch(SQLException e) {
            log.error("DataDocument::createDocument() : " + e);
            log.error("DataDocument::createDocument() : SQL : " + sql);
            throw new DataException("Erreur lors de la cr\u00E9ation du document");
        }
    }

    /**
	 * Suppression d'un document
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du document  supprimer
	 * @param intranet L'identifiant de l'intranet
	 * @throws DataException
	 */
    public void removeDocument(Query query, String id, String intranet) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataDocument::removeDocument()");
        }
		
		String sql = "DELETE FROM INT_DOCUMENT WHERE ID_DOC = '" + id + "' AND ID_INT = '" + intranet + "'";
		
		try {
			query.setSql(sql);
			query.delete();
		}
		catch(SQLException e) {
		    log.error("DataDocument::removeDocument() : " + e);
		    log.error("DataDocument::removeDocument() : SQL : " + sql);
			throw new DataException("Erreur lors de la la suppression du document");
		}
    }

    /**
	 * Mise  jour d'un document
	 * @param query La connexion  utiliser
	 * @param doc Le document  mettre  jour
	 * @throws DataException
	 */
    public void updateDocument(Query query, Document doc) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataDocument::updateDocument()");
        }
		
		StringBuffer sql = new StringBuffer();
		sql.append("UPDATE INT_DOCUMENT SET ");
		sql.append("NOM_DOC = '" + RDBMServices.sqlEscape(doc.getName()) + "', ");
		sql.append("DES_DOC = '" + RDBMServices.sqlEscape(doc.getDescription()) + "', ");
		sql.append("FILE_DOC = '" + RDBMServices.sqlEscape(doc.getFile()) + "', ");
		sql.append("AUT_DOC = '" + doc.getAuthor() + "', ");
		sql.append("DATE_DOC = '" + doc.getModificationDate() + "', ");
		sql.append("LIMIT_DOC = '" + doc.getLimitDate() + "', ");
		if(doc.getType() == Document.FILE) {
			sql.append("EXT_DOC = '" + doc.getExtension() + "', ");
		}
		if(doc.isLocked()) {
			sql.append("LOCK_DOC = '1', ");
		}
		else {
			sql.append("LOCK_DOC = '0', ");
		}
		sql.append("ORDER_DOC = " + doc.getOrder() + " ");
		sql.append("WHERE ID_DOC = '" + doc.getId() + "' AND ID_INT = '" + doc.getIntranet() + "'");	
		
		try {
			query.setSql(sql.toString());
			query.update();
		}
		catch(SQLException e) {
		    log.error("DataDocument::updateDocument() : " + e);
		    log.error("DataDocument::updateDocument() : SQL : " + sql);
			throw new DataException("Erreur lors de la mise \u00E0 jour du document");
		}
    }

    /**
	 * Validation d'un document
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du document  valider
	 * @param intranet L'identifiant de l'intranet
	 * @throws DataException
	 */
    public void validDocument(Query query, String id, String intranet) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataDocument::validDocument()");
        }
		String sql = "UPDATE INT_DOCUMENT SET ID_DOC = '" + id + "', NEW_DOC = '0' WHERE ID_DOC = '" + "i" + id.substring(1) + "' AND ID_INT = '" + intranet + "'";
		try {
			query.setSql(sql);
			query.update();				
		}
		catch(SQLException e) {
		    log.error("DataDocument::validDocument() : " + e);
		    log.error("DataDocument::validDocument() : SQL : " + sql);
			throw new DataException("Erreur lors de la validation du document");
		}
    }
    
    /**
	 * Invalidation d'un document
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du document  invalider
	 * @param intranet L'identifiant de l'intranet
	 * @throws DataException
	 */
    public void invalidDocument(Query query, String id, String intranet) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataDocument::invalidDocument()");
        }
		String sql = "UPDATE INT_DOCUMENT SET ID_DOC = '" + id + "', NEW_DOC = '1' WHERE ID_DOC = '" + "v" + id.substring(1) + "' AND ID_INT = '" + intranet + "'";
		try {
			query.setSql(sql);
			query.update();				
		}
		catch(SQLException e) {
		    log.error("DataDocument::invalidDocument() : " + e);
		    log.error("DataDocument::invalidDocument() : SQL : " + sql);
			throw new DataException("Erreur lors de l'invalidation du document");
		}
    }
    
    /**
	 * Identifiant du prochain document
	 * @param query La connexion  utiliser
	 * @return int L'identifiant
	 * @throws DataException
	 */
	public int getNextDocument(Query query, String intranet) throws DataException {
	    if(log.isDebugEnabled()) {
            log.debug("DataDocument::getNextDocument()");
	    }
		int res = 0;
		
		String sql = "SELECT DOC_INT FROM INT_INTRANET WHERE ID_INT = '" + intranet + "'";
		try {
			query.setSql(sql);
			query.select();
			ResultSet result = query.getRs();
			if(!result.next()) {
				throw new DataException("Erreur lors de la r\u00E9cup\u00E9ration de l'identifiant");
			}
			res = result.getInt("DOC_INT");
			sql = "UPDATE INT_INTRANET SET DOC_INT = " + (res+1) + " WHERE ID_INT = '" + intranet + "'";
			query.setSql(sql);
			query.update();
		}
		catch(SQLException e) {
		    log.error("DataDocument::getNextDocument() : " + e);
		    log.error("DataDocument::getNextDocument() : SQL : " + sql);
			throw new DataException("Erreur lors de la r\u00E9cup\u00E9ration de l'identifiant");
		}
		return res;
	}

    /**
	 * Vrification existence d'un document
	 * @param query La connexion  utiliser
	 * @param doc Le document  vrifier
	 * @return boolean True si le document existe, false sinon
	 */
    public boolean documentExist(Query query, Document doc) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataDocument::documentExist()");
        }
        
        String sql = "SELECT * FROM INT_DOCUMENT WHERE NOM_DOC = '" + RDBMServices.sqlEscape(doc.getName()) + "' AND ID_DOS = '" + doc.getFolder() + "'";
        try {
            query.setSql(sql);
            query.select();
            ResultSet result = query.getRs();
            if(result.next()) {
                return true;
            }
            else {
                return false;
            }
        }
        catch(SQLException e) {
            log.error("DataDocument::documentExist() : " + e);
            log.error("DataDocument::documentExist() : SQL : " + sql);
            throw new DataException("Erreur lors de la v\u00E9rification d'existence du document");
        }
    }
    
    /**
	 * Vrification verrouillage d'un document
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du document  vrifier
	 * @param intranet L'identifiant de l'intranet
	 * @return boolean True si le document est verrouill, faux sinon
	 * @throws DataException
	 */
	public boolean documentIsLocked(Query query, String id, String intranet) throws DataException {
	    if(log.isDebugEnabled()) {
            log.debug("DataDocument::documentIsLocked()");
	    }
	    
	    String sql = "SELECT * FROM INT_DOCUMENT WHERE ID_DOC = '" + id + "' AND ID_INT = '" + intranet + "' AND LOCK_DOC = '1'";
	    try {
	        query.setSql(sql);
	        query.select();
	        ResultSet result = query.getRs();
	        if(result.next()) {
	            return true;
	        }
	        else {
	            return false;
	        }
	    }
	    catch(SQLException e) {
	        log.error("DataDocument::documentIsLocked() : " + e);
	        log.error("DataDocument::documentIsLocked() : SQL : " + sql);
			throw new DataException("Erreur lors la v\u00E9rification de verrouillage du document");
	    }
	}

	/**
	 * Verrouille le document
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du document  verrouiller
	 * @param intranet L'identifiant de l'intranet
	 * @throws DataException
	 */
	public void lockDocument(Query query, String id, String intranet) throws DataException {
	    if(log.isDebugEnabled()) {
            log.debug("DataDocument::lockDocument()");   
	    }
	    
	    String sql = "UPDATE INT_DOCUMENT SET LOCK_DOC = '1' WHERE ID_DOC = '" + id + "' AND ID_INT = '" + intranet + "'";
		try {
			query.setSql(sql);
			query.update();
		}
		catch(SQLException e) {
		    log.error("DataDocument::lockDocument() : " + e);
		    log.error("DataDocument::lockDocument() : SQL : " + sql);
			throw new DataException("Erreur lors du verrouillage du document");
		}
	}
	
	/**
	 * Dverrouille le document
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du document  dverrouiller
	 * @param intranet L'identifiant de l'intranet
	 * @throws DataException
	 */
	public void unlockDocument(Query query, String id, String intranet) throws DataException {
	    if(log.isDebugEnabled()) {
            log.debug("DataDocument::unlockDocument()");
	    }
	    
	    String sql = "UPDATE INT_DOCUMENT SET LOCK_DOC = '0' WHERE ID_DOC = '" + id + "' AND ID_INT = '" + intranet + "'";
		try {
			query.setSql(sql);
			query.update();
		}
		catch(SQLException e) {
		    log.error("DataDocument::unlockDocument() : " + e);
		    log.error("DataDocument::unlockDocument() : SQL : " + sql);
			throw new DataException("Erreur lors du verrouillage du document");
		}
	}
}
