package org.esupportail.portal.channels.CIntranet.data;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.config.Config;

/**
 * DataFactory<br>
 * <br>
 * Fabrique de IDataControler et de sous-classes d'accs aux donnes<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */

public class DataFactory {
	
    protected static final Log log = LogFactory.getLog(DataFactory.class);
	
	/**
	 * Construit un IDataControler
	 * @return Le IDataControler
	 */
	public static IDataControler make() {
	    Class dataControlerClass = null;
		Object dataControlerObject = null;
		IDataControler res = null;
		String classname = Config.getInstance().getDataControler();
		
		if(classname == null) {
		    log.fatal("DataFactory::make() : classname null");
		    return res;
		}
		
		try {
		    if(log.isDebugEnabled()) {
		        log.debug("DataFactory::make() : Tentative d'instanciation du DataControler " + classname);
		    }
		    dataControlerClass = Class.forName(classname);
		    dataControlerObject = dataControlerClass.newInstance();
		    res = (IDataControler)dataControlerObject;
		}
		catch(Exception e) {
		    res = null;
		    log.fatal("DataFactory::make() : Echec de l'instanciation du DataControler " + classname);
		    log.fatal("DataFactory::make() : Exception " + e);
		}
		return res;
	}
	
	/**
	 * Construit un IDataDocument
	 * @return Le IDataDocument
	 */
	public static IDataDocument makeDocument() {
	    Class dataDocumentClass = null;
		Object dataDocumentObject = null;
		IDataDocument res = null;
		String classname = Config.getInstance().getDataDocument();
		
		if(classname == null) {
		    log.fatal("DataFactory::make() : classname null");
		    return res;
		}
		
		try {
		    if(log.isDebugEnabled()) {
		        log.debug("DataFactory::make() : Tentative d'instanciation du DataDocument " + classname);
		    }
		    dataDocumentClass = Class.forName(classname);
		    dataDocumentObject = dataDocumentClass.newInstance();
		    res = (IDataDocument)dataDocumentObject;
		}
		catch(Exception e) {
		    res = null;
		    log.fatal("DataFactory::make() : Echec de l'instanciation du DataDocument " + classname);
		    log.fatal("DataFactory::make() : Exception " + e);
		}
		return res;
	}
	
	/**
	 * Construit un IDataFolder
	 * @return Le IDataFolder
	 */
	public static IDataFolder makeFolder() {
	    Class dataFolderClass = null;
		Object dataFolderObject = null;
		IDataFolder res = null;
		String classname = Config.getInstance().getDataFolder();
		
		if(classname == null) {
		    log.fatal("DataFactory::make() : classname null");
		    return res;
		}
		
		try {
		    if(log.isDebugEnabled()) {
		        log.debug("DataFactory::make() : Tentative d'instanciation du DataFolder " + classname);
		    }
		    dataFolderClass = Class.forName(classname);
		    dataFolderObject = dataFolderClass.newInstance();
		    res = (IDataFolder)dataFolderObject;
		}
		catch(Exception e) {
		    res = null;
		    log.fatal("DataFactory::make() : Echec de l'instanciation du DataFolder " + classname);
		    log.fatal("DataFactory::make() : Exception " + e);
		}
		return res;
	}
	
	/**
	 * Construit un IDataIntranet
	 * @return Le IDataIntranet
	 */
	public static IDataIntranet makeIntranet() {
	    Class dataIntranetClass = null;
		Object dataIntranetObject = null;
		IDataIntranet res = null;
		String classname = Config.getInstance().getDataIntranet();
		
		if(classname == null) {
		    log.fatal("DataFactory::make() : classname null");
		    return res;
		}
		
		try {
		    if(log.isDebugEnabled()) {
		        log.debug("DataFactory::make() : Tentative d'instanciation du DataIntranet " + classname);
		    }
		    dataIntranetClass = Class.forName(classname);
		    dataIntranetObject = dataIntranetClass.newInstance();
		    res = (IDataIntranet)dataIntranetObject;
		}
		catch(Exception e) {
		    res = null;
		    log.fatal("DataFactory::make() : Echec de l'instanciation du DataIntranet " + classname);
		    log.fatal("DataFactory::make() : Exception " + e);
		}
		return res;
	}
	
	/**
	 * Construit un IDataMIME
	 * @return Le IDataMIME
	 */
	public static IDataMIME makeMIME() {
	    Class dataMIMEClass = null;
		Object dataMIMEObject = null;
		IDataMIME res = null;
		String classname = Config.getInstance().getDataMIME();
		
		if(classname == null) {
		    log.fatal("DataFactory::make() : classname null");
		    return res;
		}
		
		try {
		    if(log.isDebugEnabled()) {
		        log.debug("DataFactory::make() : Tentative d'instanciation du DataMIME " + classname);
		    }
		    dataMIMEClass = Class.forName(classname);
		    dataMIMEObject = dataMIMEClass.newInstance();
		    res = (IDataMIME)dataMIMEObject;
		}
		catch(Exception e) {
		    res = null;
		    log.fatal("DataFactory::make() : Echec de l'instanciation du DataMIME " + classname);
		    log.fatal( "DataFactory::make() : Exception " + e);
		}
		return res;
	}
	
	/**
	 * Construit un IDataOrder
	 * @return Le IDataOrder
	 */
	public static IDataOrder makeOrder() {
	    Class dataOrderClass = null;
		Object dataOrderObject = null;
		IDataOrder res = null;
		String classname = Config.getInstance().getDataOrder();
		
		if(classname == null) {
		    log.fatal("DataFactory::make() : classname null");
		    return res;
		}
		
		try {
		    if(log.isDebugEnabled()) {
		        log.debug("DataFactory::make() : Tentative d'instanciation du DataOrder " + classname);
		    }
		    dataOrderClass = Class.forName(classname);
		    dataOrderObject = dataOrderClass.newInstance();
		    res = (IDataOrder)dataOrderObject;
		}
		catch(Exception e) {
		    res = null;
		    log.fatal("DataFactory::make() : Echec de l'instanciation du DataOrder " + classname);
		    log.fatal("DataFactory::make() : Exception " + e);
		}
		return res;
	}
	
	/**
	 * Construit un IDataPopulation
	 * @return Le IDataPopulation
	 */
	public static IDataPopulation makePopulation() {
	    Class dataPopulationClass = null;
		Object dataPopulationObject = null;
		IDataPopulation res = null;
		String classname = Config.getInstance().getDataPopulation();
		
		if(classname == null) {
		    log.fatal("DataFactory::make() : classname null");
		    return res;
		}
		
		try {
		    if(log.isDebugEnabled()) {
		        log.debug("DataFactory::make() : Tentative d'instanciation du DataPopulation " + classname);
		    }
		    dataPopulationClass = Class.forName(classname);
		    dataPopulationObject = dataPopulationClass.newInstance();
		    res = (IDataPopulation)dataPopulationObject;
		}
		catch(Exception e) {
		    res = null;
		    log.fatal("DataFactory::make() : Echec de l'instanciation du DataPopulation " + classname);
		    log.fatal("DataFactory::make() : Exception " + e);
		}
		return res;
	}
	
	/**
	 * Construit un IDataPublicator
	 * @return Le IDataPublicator
	 */
	public static IDataPublicator makePublicator() {
	    Class dataPublicatorClass = null;
		Object dataPublicatorObject = null;
		IDataPublicator res = null;
		String classname = Config.getInstance().getDataPublicator();
		
		if(classname == null) {
		    log.fatal("DataFactory::make() : classname null");
		    return res;
		}
		
		try {
		    if(log.isDebugEnabled()) {
		        log.debug("DataFactory::make() : Tentative d'instanciation du DataPublicator " + classname);
		    }
		    dataPublicatorClass = Class.forName(classname);
		    dataPublicatorObject = dataPublicatorClass.newInstance();
		    res = (IDataPublicator)dataPublicatorObject;
		}
		catch(Exception e) {
		    res = null;
		    log.fatal("DataFactory::make() : Echec de l'instanciation du DataPublicator " + classname);
		    log.fatal("DataFactory::make() : Exception " + e);
		}
		return res;
	}
	
	/**
	 * Construit un IDataSU
	 * @return Le IDataSU
	 */
	public static IDataSU makeSU() {
	    Class dataSUClass = null;
		Object dataSUObject = null;
		IDataSU res = null;
		String classname = Config.getInstance().getDataSU();
		
		if(classname == null) {
		    log.fatal("DataFactory::make() : classname null");
		    return res;
		}
		
		try {
		    if(log.isDebugEnabled()) {
		        log.debug("DataFactory::make() : Tentative d'instanciation du DataSU " + classname);
		    }
		    dataSUClass = Class.forName(classname);
		    dataSUObject = dataSUClass.newInstance();
		    res = (IDataSU)dataSUObject;
		}
		catch(Exception e) {
		    res = null;
		    log.fatal("DataFactory::make() : Echec de l'instanciation du DataSU " + classname);
		    log.fatal("DataFactory::make() : Exception " + e);
		}
		return res;
	}
	
	/**
	 * Construit un IDataValidator
	 * @return Le IDataValidator
	 */
	public static IDataValidator makeValidator() {
	    Class dataValidatorClass = null;
		Object dataValidatorObject = null;
		IDataValidator res = null;
		String classname = Config.getInstance().getDataValidator();
		
		if(classname == null) {
		    log.fatal("DataFactory::make() : classname null");
		    return res;
		}
		
		try {
		    if(log.isDebugEnabled()) {
		        log.debug("DataFactory::make() : Tentative d'instanciation du DataValidator " + classname);
		    }
		    dataValidatorClass = Class.forName(classname);
		    dataValidatorObject = dataValidatorClass.newInstance();
		    res = (IDataValidator)dataValidatorObject;
		}
		catch(Exception e) {
		    res = null;
		    log.fatal("DataFactory::make() : Echec de l'instanciation du DataValidator " + classname);
		    log.fatal("DataFactory::make() : Exception " + e);
		}
		return res;
	}
}
