package org.esupportail.portal.channels.CIntranet.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Folder;
import org.esupportail.portal.channels.CIntranet.beans.FolderTree;
import org.esupportail.portal.channels.CIntranet.beans.Path;
import org.esupportail.portal.channels.CIntranet.beans.SubFolder;
import org.esupportail.portal.utils.database.Query;
import org.jasig.portal.RDBMServices;

/**
 * DataFolder<br>
 * <br>
 * Classe d'accs aux donnes manipulant les dossiers<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */
public class DataFolder implements IDataFolder {
    
    protected static final Log log = LogFactory.getLog(DataFolder.class);

    /**
	 * Rcupration d'un dossier
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @return Le dossier
	 * @throws DataException
	 */
    public Folder getFolder(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataDocument::getFolder()");
        }
		Folder res = new Folder();
		
		String sql = "SELECT * FROM INT_DOSSIER WHERE ID_DOS = '" + id + "'";
		try {
			query.setSql(sql);
			query.select();
			ResultSet result = query.getRs();
			if(!result.next()) {
			    if(log.isDebugEnabled()) {
		            log.debug("DataDocument::getFolder() : Aucun dossier ayant pour ID = " + id);
			    }
				throw new DataException("Impossible d'acc\u00E9der \u00E0 ce dossier");
			}
			res.setId(id);
			res.setIntranet(result.getString("ID_INT"));
			res.setName(result.getString("NOM_DOS"));
			res.setParent(result.getString("ID_PAR"));
			String val = result.getString("VAL_DOS");
			if(val.equals("1")) {
				res.setValidation(true);
			}
			else {
				res.setValidation(false);
			}
		}
		catch(SQLException e) {
			log.error("DataDocument::getFolder() : " + e);
			log.error("DataDocument::getFolder() : SQL : " + sql);
			throw new DataException("Impossible d'acc\u00E9der \u00E0 ce dossier");
		}
		return res;
    }

    /**
	 * Rcupration d'un sous-dossier
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du sous-dossier
	 * @return Le sous-dossier
	 * @throws DataException
	 */
    public SubFolder getSubFolder(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataDocument::getSubFolder()");
        }
		SubFolder res = new SubFolder();
		
		String sql = "SELECT * FROM INT_DOSSIER WHERE ID_DOS = '" + id + "'";
		try {
			query.setSql(sql);
			query.select();
			ResultSet result = query.getRs();
			if(!result.next()) {
			    if(log.isDebugEnabled()) {
		            log.debug("DataDocument::getSubFolder() : Aucun dossier ayant pour ID = " + id);
			    }
				throw new DataException("Impossible d'acc\u00E9der \u00E0 ce dossier");
			}
			res.setId(id);
			res.setIntranet(result.getString("ID_INT"));
			res.setName(result.getString("NOM_DOS"));
			res.setParent(result.getString("ID_PAR"));
		}
		catch(SQLException e) {
		    log.error("DataDocument::getSubFolder() : " + e);
		    log.error("DataDocument::getSubFolder() : SQL : " + sql);
			throw new DataException("Impossible d'acc\u00E9der \u00E0 ce dossier");
		}
		return res;
    }

    /**
	 * Rcupration des sous-dossiers
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier parent
	 * @return La liste des sous-dossiers
	 * @throws DataException
	 */
    public Collection getSubFolders(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataDocument::getSubFolders()");
        }
		Collection res = new Vector();
		
		String sql = "SELECT * FROM INT_DOSSIER WHERE ID_PAR = '" + id + "' ORDER BY NOM_DOS";
		
		try {
			query.setSql(sql);
			query.select();
			ResultSet result = query.getRs();
			while(result.next()) {
				SubFolder tmp = new SubFolder();
				tmp.setId(result.getString("ID_DOS"));
				tmp.setIntranet(result.getString("ID_INT"));
				tmp.setName(result.getString("NOM_DOS"));
				tmp.setParent(result.getString("ID_PAR"));
				res.add(tmp);
			}
		}
		catch(SQLException e) {
		    log.error("DataDocument::getSubFolders() : " + e);
		    log.error("DataDocument::getSubFolders() : SQL : " + sql);
			throw new DataException("Erreur lors de la lecture des sous dossiers");
		}
		return res;
    }

    /**
	 * Cration d'un dossier
	 * @param query La connexion  utiliser
	 * @param folder Le dossier  crer
	 * @return L'identifiant du dossier cr
	 */
    public void createFolder(Query query, Folder folder) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug( "DataDocument::createFolder()");
        }
		
		StringBuffer sql = new StringBuffer();
		sql.append("INSERT INTO INT_DOSSIER(ID_DOS, ID_INT, ID_PAR, NOM_DOS, VAL_DOS) VALUES(");
		sql.append(folder.getId() + ", ");
		sql.append("'" + folder.getIntranet() + "', ");
		sql.append(folder.getParent() + ", ");
		sql.append("'" + RDBMServices.sqlEscape(folder.getName()) + "', ");
		if(folder.isValidation()) {
			sql.append("'1')");
		}
		else {
			sql.append("'0')");
		}
		try {
			query.setSql(sql.toString());
			query.insert();
		}
		catch(SQLException e) {
		    log.error("DataDocument::createFolder() : " + e);
		    log.error("DataDocument::createFolder() : SQL : " + sql.toString());
			throw new DataException("Erreur lors de la cr\u00E9ation du dossier");
		}
    }

    /**
	 * Suppression d'un dossier
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @throws DataException
	 */
    public void removeFolder(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataDocument::removeFolder()");
        }
		
		String sql = sql = "DELETE FROM INT_DOSSIER WHERE ID_DOS = " + id;
		try {
			// Suppression dossier
			
			query.setSql(sql);
			query.delete();
		}
		catch(SQLException e) {
		    log.error("DataDocument::removeFolder() : " + e);
		    log.error("DataDocument::removeFolder() : SQL : " + sql);
			throw new DataException("Erreur lors de la suppression du dossier");
		}
    }

    /**
	 * Modifie la validation d'un dossier
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @param validation True pour activer la validation, false pour la dsactiver
	 * @throws DataException
	 */
	public void setValidation(Query query, String id, boolean validation) throws DataException {
	    if(log.isDebugEnabled()) {
            log.debug("DataDocument::setValidation()");
	    }
		String sql = null;
		if(validation) {
			sql = "UPDATE INT_DOSSIER SET VAL_DOS = '1' WHERE ID_DOS = " + id;
		}
		else {
		    sql = "UPDATE INT_DOSSIER SET VAL_DOS = '0' WHERE ID_DOS = " + id;
		}
		
		try {
			query.setSql(sql);
			query.update();
		}
		catch(SQLException e) {
		    log.error("DataDocument::setValidation() : " + e);
		    log.error("DataDocument::setValidation() : SQL : " + sql);
			throw new DataException("Erreur lors du changement de validation du dossier");
		}
	}
	
	/**
	 * Modifie le nom d'un dossier
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @param name Le nouveau nom du dossier
	 * @throws DataException
	 */
	public void setName(Query query, String id, String name) throws DataException {
	    if(log.isDebugEnabled()) {
            log.debug("DataDocument::setName()");
	    }
		String sql = "UPDATE INT_DOSSIER SET NOM_DOS = '" + RDBMServices.sqlEscape(name) + "' WHERE ID_DOS = " + id;
		
		try {
			query.setSql(sql);
			query.update();
		}
		catch(SQLException e) {
		    log.error("DataDocument::setName() : " + e);
		    log.error("DataDocument::setName() : SQL : " + sql);
			throw new DataException("Erreur lors de la mise \u00E9 jour du dossier");
		}
	}
    
    /**
	 * Identifiant du prochain dossier
	 * @param query La connexion  utiliser
	 * @return int L'identifiant
	 * @throws DataException
	 */
	public int getNextFolder(Query query) throws DataException {
	    if(log.isDebugEnabled()) {
            log.debug("DataDocument::getNextFolder()");
	    }
		int res = 0;
		
		String sql = "SELECT CLE FROM INT_CLE WHERE NOM_TABLE = 'INT_DOSSIER'";
		try {
			query.setSql(sql);
			query.select();
			ResultSet result = query.getRs();
			if(!result.next()) {
				throw new DataException("Erreur lors de la r\u00E9cup\u00E9ration de l'identifiant");
			}
			res = result.getInt("CLE");
			sql = "UPDATE INT_CLE SET CLE = " + (res+1) + " WHERE NOM_TABLE = 'INT_DOSSIER'";
			query.setSql(sql);
			query.update();
		}
		catch(SQLException e) {
		    log.error("DataFolder::getNextFolder() : " + e);
		    log.error("DataFolder::getNextFolder() : SQL : " + sql);
			throw new DataException("Erreur lors de la r\u00E9cup\u00E9ration de l'identifiant");
		}
		return res;
	}
    
    /**
	 * Vrification existence d'un dossier
	 * @return boolean True si le dossier existe, faux sinon
	 * @throws DataException
	 */
	public boolean folderExist(Query query, Folder folder) throws DataException {
	    if(log.isDebugEnabled()) {
            log.debug("DataFolder::folderExist()");
	    }
	    
	    String sql = "SELECT * FROM INT_DOSSIER WHERE ID_PAR = " + folder.getParent() + " AND NOM_DOS = '" + folder.getName() + "'";
	    try {
	        query.setSql(sql);
	        query.select();
	        ResultSet result = query.getRs();
	        if(result.next()) {
	            return true;
	        }
	        return false;
	    }
	    catch(SQLException e) {
	        log.error("DataFolder::folderExist() : " + e);
	        log.error("DataFolder::folderExist() : SQL : " + sql);
			throw new DataException("Erreur lors de la v\u00E9rification d'existence du document");
	    }
	}
	
	/**
	 * Vrifie si un dossier est vide
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @return boolean True si le dossier est vide, faux sinon
	 * @throws DataException
	 */
	public boolean isFolderEmpty(Query query, String id) throws DataException {
	    if(log.isDebugEnabled()) {
            log.debug("DataFolder::isFolderEmpty()");
	    }
	    
	    String sql = "SELECT * FROM INT_DOSSIER WHERE ID_PAR = " + id;
	    try {
	        query.setSql(sql);
	        query.select();
	        ResultSet result = query.getRs();
	        if(result.next()) {
	            return false;
	        }
	        sql = "SELECT * FROM INT_DOCUMENT WHERE ID_DOS = " + id;
	        query.setSql(sql);
	        query.select();
	        result = query.getRs();
	        if(result.next()) {
	            return false;
	        }
	        return true;
	    }
	    catch(SQLException e) {
	        log.error("DataFolder::isFolderEmpty() : " + e);
	        log.error("DataFolder::isFolderEmpty() : SQL : " + sql);
			throw new DataException("Erreur lors de la v\u00E9rification de dossier vide");
	    }
	}
	
	/**
	 * Construit le chemin d'un dossier
	 * @param id L'identifiant du dossier
	 * @return Path le chemin du dossier
	 * @throws DataException
	 */
	public Path getPath(Query query, String id) throws DataException {
	    if(log.isDebugEnabled()) {
            log.debug("DataFolder::getPath()");
	    }
		
		LinkedList path = new LinkedList();
		String currentId = id;
		SubFolder tmp = null;
		do {
			tmp = getSubFolder(query, currentId);
			currentId = tmp.getParent();
			path.addFirst(tmp);
		}
		while(!currentId.equals("0"));
		Path res = new Path(path);
		return res;
	}
	
	/**
	 * Retourne la liste de tous les sous-dossiers d'un dossier
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @return Collection La liste des sous-dossiers
	 * @throws DataException
	 */
	public Collection getFolderChildren(Query query, String id) throws DataException {
	    if(log.isDebugEnabled()) {
            log.debug("DataFolder::getFolderChildren()");
	    }
	    
	    Collection res = new Vector();
		Collection children = new Vector();
		
		res = getSubFolders(query, id);
		
		Iterator i = res.iterator();
		while(i.hasNext()) {
			SubFolder tmp = (SubFolder)i.next();
			children.addAll(getFolderChildren(query, tmp.getId()));
		}
		res.addAll(children);
		return res;
	}

	/**
     * Construit rcursivement l'arborescence d'un dossier
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @return La structure de l'arbre
     * @throws DataException
     */
	public Collection getFolderTree(Query query, String id) throws DataException {
	    if(log.isDebugEnabled()) {
            log.debug("DataFolder::getFolderTree()");
	    }
        
        Collection res = new Vector();
        String sql = "SELECT * FROM INT_DOSSIER WHERE ID_PAR = '" + id + "'";
        try {
            query.setSql(sql);
            query.select();
            ResultSet result = query.getRs();
            while(result.next()) {
                FolderTree tmp = new FolderTree();
                tmp.setId(result.getString("ID_DOS"));
				tmp.setIntranet(result.getString("ID_INT"));
				tmp.setName(result.getString("NOM_DOS"));
				tmp.setParent(result.getString("ID_PAR"));
				res.add(tmp);
            }
        }
        catch(SQLException e) {
            
        }
        Iterator i = res.iterator();
        while(i.hasNext()) {
            FolderTree tmp = (FolderTree)i.next();
            tmp.setSubfolder(getFolderTree(query, tmp.getId()));
        }
	    return res;
    }
}
