package org.esupportail.portal.channels.CIntranet.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.User;
import org.esupportail.portal.utils.database.Query;

/**
 * DataPublicator<br>
 * <br>
 * Classe d'accs aux donnes manipulant les publicateurs<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */
public class DataPublicator implements IDataPublicator {
    
    protected static final Log log = LogFactory.getLog(DataPublicator.class);

    /**
	 * Rcupration des publicateurs d'un dossier
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @return La liste des publicateurs
	 * @throws DataException
	 */
    public Collection getUsersPublicators(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataPublicator::getUsersPublicators()");
        }
		Collection res = new Vector();
		
		String sql = "SELECT ID_PUB FROM INT_PUBLICATEUR WHERE TYPE_PUB = 'U' AND ID_DOS = '" + id + "'";
		
		try {
			query.setSql(sql);
			query.select();
			ResultSet result = query.getRs();
			while(result.next()) {
			    User tmp = new User();
			    tmp.setLogin(result.getString("ID_PUB"));
				res.add(tmp);
			}
		}
		catch(SQLException e) {
			log.error("DataPublicator::getUsersPublicators() : " + e);
			log.error("DataPublicator::getUsersPublicators() : SQL : " + sql);
			throw new DataException("Erreur lors de la lecture des publicateurs");
		}
		return res;
    }

    /**
	 * Rcupration des groupes de publicateurs d'un dossier
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @return La liste des groupes de publicateurs
	 * @throws DataException
	 */
    public Collection getGroupsPublicators(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataPublicator::getGroupsPublicators()");
        }
		Collection res = new Vector();
		
		String sql = "SELECT ID_PUB FROM INT_PUBLICATEUR WHERE TYPE_PUB = 'G' AND ID_DOS = '" + id + "'";
		
		try {
			query.setSql(sql);
			query.select();
			ResultSet result = query.getRs();
			while(result.next()) {
				res.add(result.getString("ID_PUB"));
			}
		}
		catch(SQLException e) {
			log.error("DataPublicator::getGroupsPublicators() : " + e);
			log.error("DataPublicator::getGroupsPublicators() : SQL : " + sql);
			throw new DataException("Erreur lors de la lecture des groupes de publicateurs");
		}
		return res;
    }

    /**
	 * Ajout d'un publicateur
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @param login L'identifiant de l'utilisateur
	 */
    public void addPublicator(Query query, String id, String login) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataPublicator::addPublicator()");
        }
		
		StringBuffer sql = new StringBuffer();
		sql.append("INSERT INTO INT_PUBLICATEUR(ID_DOS, TYPE_PUB, ID_PUB) VALUES(");
		sql.append("'" + id + "', ");
		sql.append("'U', ");
		sql.append("'" + login + "');");
		
		try {
			query.setSql(sql.toString());
			query.insert();
		}
		catch(SQLException e) {
			log.error("DataPublicator::addPublicator() : " + e);
			log.error("DataPublicator::addPublicator() : SQL : " + sql);
			throw new DataException("Erreur lors de l'ajout du publicateur");
		}
    }

    /**
	 * Ajout d'une liste de publicateurs
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @param logins La liste des identifiants
	 */
	public void addPublicator(Query query, String id, Collection logins) throws DataException {
	    if(log.isDebugEnabled()) {
            log.debug("DataPublicator::addPublicator()");
	    }
		
	    Iterator i = logins.iterator();
	    while(i.hasNext()) {
	        String login = (String)i.next();
	        addPublicator(query, id, login);
	    }
	}
    
    /**
	 * Ajout d'un groupe de publicateurs
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @param group L'identifiant du groupe
	 * @throws DataException
	 */
    public void addPublicators(Query query, String id, String group) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataPublicator::addPublicators()");
        }
		
		StringBuffer sql = new StringBuffer();
		sql.append("INSERT INTO INT_PUBLICATEUR(ID_DOS, TYPE_PUB, ID_PUB) VALUES(");
		sql.append("'" + id + "', ");
		sql.append("'G', ");
		sql.append("'" + group + "')");

		try {
			query.setSql(sql.toString());
			query.insert();			
		}
		catch(SQLException e) {
			log.error("DataPublicator::addPublicators() : " + e);
			log.error("DataPublicator::addPublicators() : SQL : " + sql);
			throw new DataException("Erreur lors de l'ajout du groupe de publicateurs");
		}
    }
    
    /**
	 * Ajout d'une liste de groupes de publicateurs
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @param groups La liste des identifiants de groupes
	 * @throws DataException
	 */
	public void addPublicators(Query query, String id, Collection groups) throws DataException {
	    if(log.isDebugEnabled()) {
            log.debug("DataPublicator::addPublicators()");
	    }
		
		Iterator i = groups.iterator();
	    while(i.hasNext()) {
	        String group = (String)i.next();
	        addPublicators(query, id, group);
	    }
	}

    /**
	 * Suppression d'un publicateur
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @param login L'identifiant de l'utilisateur
	 * @throws DataException
	 */
    public void removePublicator(Query query, String id, String login) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataPublicator::removePublicator()");
        }
		
		StringBuffer sql = new StringBuffer();
		sql.append("DELETE FROM INT_PUBLICATEUR WHERE ");
		sql.append("ID_DOS = '" + id + "' AND ");
		sql.append("TYPE_PUB = 'U' AND ");
		sql.append("ID_PUB = '" + login + "'");
		
		try {
			query.setSql(sql.toString());
			query.delete();
		}
		catch(SQLException e) {
			log.error("DataPublicator::removePublicator() : " + e);
			log.error("DataPublicator::removePublicator() : SQL : " + sql);
			throw new DataException("Erreur lors de la suppression du publicateur");
		}
    }

    /**
	 * Suppression d'un groupe de publicateurs
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @param group L'identifiant du groupe
	 * @throws DataException
	 */
    public void removePublicators(Query query, String id, String group) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataPublicator::removePublicators()");
        }
		
		StringBuffer sql = new StringBuffer();
		sql.append("DELETE FROM INT_PUBLICATEUR WHERE ");
		sql.append("ID_DOS = '" + id + "' AND ");
		sql.append("TYPE_PUB = 'G' AND ");
		sql.append("ID_PUB = '" + group + "'");
		
		try {
			query.setSql(sql.toString());
			query.delete();
		}
		catch(SQLException e) {
			log.error("DataPublicator::removePublicators() : " + e);
			log.error("DataPublicator::removePublicators() : SQL : " + sql);
			throw new DataException("Erreur lors de la suppression du groupe de publicateurs");
		}
    }

    /**
	 * Suppression de tous les publicateurs d'un dossier
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @throws DataException
	 */
    public void removeAllPublicators(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataPublicator::removeAllPublicators()");
        }
		
		StringBuffer sql = new StringBuffer();
		sql.append("DELETE FROM INT_PUBLICATEUR WHERE ");
		sql.append("ID_DOS = '" + id + "'");
		
		try {
			query.setSql(sql.toString());
			query.delete();
		}
		catch(SQLException e) {
			log.error("DataPublicator::removeAllPublicators() : " + e);
			log.error("DataPublicator::removeAllPublicators() : SQL : " + sql);
			throw new DataException("Erreur lors de la suppression des publicateurs");
		}
    }
}
