package org.esupportail.portal.channels.CIntranet.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.User;
import org.esupportail.portal.utils.database.Query;

/**
 * DataSU<br>
 * <br>
 * Classe d'accs aux donnes manipulant les supers-utilisateurs<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */
public class DataSU implements IDataSU {
    
    protected static final Log log = LogFactory.getLog(DataSU.class);

    /**
	 * Rcupration des super-utilisateurs
	 * @param query La connexion  utiliser
	 * @return La liste des super-utilisateurs
	 * @throws DataException
	 */
    public Collection getSuperUsers(Query query) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataSU::getSuperUsers()");
        }
		Collection res = new Vector();
		
		String sql = "SELECT LOGIN FROM INT_SUPERUSER";
		
		try {
			query.setSql(sql);
			query.select();
			ResultSet result = query.getRs();
			while(result.next()) {
			    User tmp = new User();
			    tmp.setLogin(result.getString("LOGIN"));
				res.add(tmp);
			}
		}
		catch(SQLException e) {
			log.error("DataSU::getSuperUsers() : " + e);
			log.error("DataSU::getSuperUsers() : SQL : " + sql);
			throw new DataException("Erreur lors de la lecture des super utilisateurs");
		}
		return res;
    }

    /**
	 * Ajout d'un super-utilisateur
	 * @param query La connexion  utiliser
	 * @param login L'identifiant de l'utilisateur
	 */
    public void addSuperUser(Query query, String login) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataSU::addSuperUser()");
        }
		
		StringBuffer sql = new StringBuffer();
		sql.append("INSERT INTO INT_SUPERUSER(LOGIN) VALUES(");
		sql.append("'" + login + "')");
		
		try {
			query.setSql(sql.toString());
			query.insert();
		}
		catch(SQLException e) {
			log.error("DataSU::addSuperUser() : " + e);
			log.error("DataSU::addSuperUser() : SQL : " + sql);
			throw new DataException("Erreur lors de l'ajout du super utilisateur");
		}
    }

    /**
	 * Suppression d'un super-utilisateur
	 * @param query La connexion  utiliser
	 * @param login L'identifiant de l'utilisateur
	 * @throws DataException
	 */
    public void removeSuperUser(Query query, String login) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("addSuperUser::removeSuperUser()");
        }
		
		StringBuffer sql = new StringBuffer();
		sql.append("DELETE FROM INT_SUPERUSER WHERE ");
		sql.append("LOGIN = '" + login + "'");
		
		try {
			query.setSql(sql.toString());
			query.delete();
		}
		catch(SQLException e) {
			log.error("addSuperUser::removeSuperUser() : " + e);
			log.error("addSuperUser::removeSuperUser() : SQL : " + sql);
			throw new DataException("Erreur lors de la suppression du super utilisateur");
		}
    }
}
