package org.esupportail.portal.channels.CIntranet.data;

import java.util.Collection;

import org.esupportail.portal.utils.database.Query;

/**
 * IDataPublicator<br>
 * <br>
 * Cette interface dcrit les mthodes d'accs aux publicateurs<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */
public interface IDataPublicator {

    /**
	 * Rcupration des publicateurs d'un dossier
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @return La liste des publicateurs
	 * @throws DataException
	 */
	public Collection getUsersPublicators(Query query, String id) throws DataException;
	
	/**
	 * Rcupration des groupes de publicateurs d'un dossier
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @return La liste des groupes de publicateurs
	 * @throws DataException
	 */
	public Collection getGroupsPublicators(Query query, String id) throws DataException;
	
	/**
	 * Ajout d'un publicateur
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @param login L'identifiant de l'utilisateur
	 */
	public void addPublicator(Query query, String id, String login) throws DataException;
	
	/**
	 * Ajout d'une liste de publicateurs
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @param logins La liste des identifiants
	 */
	public void addPublicator(Query query, String id, Collection logins) throws DataException;
	
	/**
	 * Ajout d'un groupe de publicateurs
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @param group L'identifiant du groupe
	 * @throws DataException
	 */
	public void addPublicators(Query query, String id, String group) throws DataException;
	
	/**
	 * Ajout d'une liste de groupes de publicateurs
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @param groups La liste des identifiants de groupes
	 * @throws DataException
	 */
	public void addPublicators(Query query, String id, Collection groups) throws DataException;
	
	/**
	 * Suppression d'un publicateur
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @param login L'identifiant de l'utilisateur
	 * @throws DataException
	 */
	public void removePublicator(Query query, String id, String login) throws DataException;
	
	/**
	 * Suppression d'un groupe de publicateurs
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @param group L'identifiant du groupe
	 * @throws DataException
	 */
	public void removePublicators(Query query, String id, String group) throws DataException;
	
	/**
	 * Suppression de tous les publicateurs d'un dossier
	 * @param query La connexion  utiliser
	 * @param id L'identifiant du dossier
	 * @throws DataException
	 */
	public void removeAllPublicators(Query query, String id) throws DataException;
}
