package org.esupportail.portal.channels.CIntranet.data;

import java.util.Collection;

import org.esupportail.portal.utils.database.Query;

/**
 * IDataSU<br>
 * <br>
 * Cette interface dcrit les mthodes d'accs aux super-utilisateurs<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */
public interface IDataSU {

    /**
	 * Rcupration des super-utilisateurs
	 * @param query La connexion  utiliser
	 * @return La liste des super-utilisateurs
	 * @throws DataException
	 */
	public Collection getSuperUsers(Query query) throws DataException;
	
	/**
	 * Ajout d'un super-utilisateur
	 * @param query La connexion  utiliser
	 * @param login L'identifiant de l'utilisateur
	 */
	public void addSuperUser(Query query, String login) throws DataException;
	
	/**
	 * Suppression d'un super-utilisateur
	 * @param query La connexion  utiliser
	 * @param login L'identifiant de l'utilisateur
	 * @throws DataException
	 */
	public void removeSuperUser(Query query, String login) throws DataException;
}
