package org.esupportail.portal.channels.CIntranet.groups;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.config.Config;

/**
 * GroupFactory<br>
 * <br>
 * Fabrique de IGroupManager<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */

public class GroupFactory {
	
    protected static final Log log = LogFactory.getLog(GroupFactory.class);
	private static IGroupManager singleton = null;
	
	/**
	 * Construit un IGroupManager et implmente un mcanisme<br>
	 * de singleton
	 * @return L'implmentation du IGroupManager correspondante
	 */
	public static IGroupManager make() {
		if(singleton != null) {
			return singleton;
		}
		
		Class groupManagerClass = null;
		Object groupManagerObject = null;
		IGroupManager res = null;
		String classname = Config.getInstance().getGroupManager();
		if(classname == null) {
		    log.fatal("GroupFactory::make() : classname null");
			return res;
		}
		
		try {
			if(log.isDebugEnabled()) {
			    log.debug("GroupFactory::make() : Tentative d'instanciation du GroupManager " + classname);
			}
			groupManagerClass = Class.forName(classname);
			groupManagerObject = groupManagerClass.newInstance();
			res = (IGroupManager)groupManagerObject;
		}
		catch(Exception e) {
			res = null;
			log.fatal("GroupFactory::make() : Echec de l'instanciation du GroupManager " + classname);
			log.fatal("GroupFactory::make() : Exception " + e);
		}
		singleton = res;
		return singleton;
	}
}
