package org.esupportail.portal.channels.CIntranet.groups;

import java.util.Collection;

import org.esupportail.portal.channels.CIntranet.beans.User;

/**
 * IGroupManager<br>
 * <br>
 * Interface dcrivant les mthodes que doit obligatoirement implmenter<br>
 * le gestionnaire de groupes<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */

public interface IGroupManager {
	
    /**
	 * Etablit la correspondance entre un login et un nom courant
	 * @param userid L'utilisateur dont on veut connatre le nom
	 * @throws GroupException
	 */
	public void getUserDisplayName(User userid);
	
	/**
	 * Etablit la correspondance entre un login et un nom courant
	 * @param userid Les utilisateurs dont on veut connatre le nom
	 * @throws GroupException
	 */
	public void getUsersDisplayName(Collection userid);
	
	/**
	 * Retourne le nom d'usage correspondant  un identifiant de groupe
	 * @param groupid L'identifiant du groupe
	 * @return Le nom d'usage
	 * @throws GroupException
	 */
	public String getGroupDisplayName(String groupid) throws GroupException;
	
	/**
	 * Indique si un utilisateur est membre d'un groupe
	 * @param userid L'identifiant de l'utilisateur
	 * @param group L'identifiant du groupe
	 * @return true si l'utilisateur est membre, false sinon
	 * @throws GroupException
	 */
	public boolean isMemberOf(String userid, String group) throws GroupException;
	
	/**
	 * Indique si un utilisateur est membre d'un des groupes d'une liste
	 * @param userid L'identifiant de l'utilisateur
	 * @param groups La liste des identifiants de groupe
	 * @return true si l'utilisateur est membre d'au moins un des groupes , false sinon
	 * @throws GroupException
	 */
	public boolean isMemberOf(String userid, Collection groups) throws GroupException;
}
