package org.esupportail.portal.channels.CIntranet.groups;

import java.util.Collection;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.User;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.security.provider.RestrictedPerson;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.services.LogService;
import org.jasig.portal.services.PersonDirectory;

/**
 * PortalGroupManager<br>
 * <br>
 * Implmentation d'un IGroupManager utilisant les groupes de uPortal<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */

public class PortalGroupManager implements IGroupManager {

    protected static final Log log = LogFactory.getLog(GroupFactory.class);
	
	/**
	 * Constructeur
	 */
	public PortalGroupManager() {
	}
	
	/**
	 * Etablit la correspondance entre un login et un nom courant
	 * @param userid L'utilisateur dont on veut connatre le nom
	 * @throws GroupException
	 */
	public synchronized void getUserDisplayName(User userid) {
		if(log.isDebugEnabled()) {
		    log.debug("PortalGroupManager::getUserDisplayName()");
		}
		
		RestrictedPerson user = null;
		Object displayName = null;
		user = PersonDirectory.getRestrictedPerson(userid.getLogin());
		if(user == null) {
		    if(log.isDebugEnabled()) {
			    log.debug("PortalGroupManager::getUserDisplayName() : Utilisateur inconnu " + userid);
		    }
		    userid.setDisplayName("Utilisateur inconnu");
		    return;
		}
		
		displayName = user.getAttribute("displayName");
		
		if(displayName == null) {
		    if(log.isDebugEnabled()) {
			    log.debug("PortalGroupManager::getUserDisplayName() : Utilisateur inconnu " + userid);
		    }
		    userid.setDisplayName("Utilisateur inconnu");
		    return;
		}
		userid.setDisplayName(displayName.toString());
	}
	
	/**
	 * Etablit la correspondance entre un login et un nom courant
	 * @param userid Les utilisateurs dont on veut connatre le nom
	 * @throws GroupException
	 */
	public synchronized void getUsersDisplayName(Collection userid) {
	    if(log.isDebugEnabled()) {
		    log.debug("PortalGroupManager::getUsersDisplayName()");
	    }
	    
	    Iterator i = userid.iterator();
	    while(i.hasNext()) {
	        User tmp = (User)i.next();
	        getUserDisplayName(tmp);
	    }
	}
	
	/**
	 * Retourne le nom d'usage correspondant  un identifiant de groupe
	 * @param groupid L'identifiant du groupe
	 * @return Le nom d'usage
	 * @throws GroupException
	 */
	public synchronized String getGroupDisplayName(String groupid) throws GroupException {
	    if(log.isDebugEnabled()) {
		    log.debug("PortalGroupManager::getGroupDisplayName()");
	    }
		
		if(groupid.equals("_EVERYBODY")) {
			return "Tous les membres";
		}
		
		Class groupType = org.jasig.portal.groups.IGroupMember.class;
		IEntityGroup myGroup = null;
		try {
			myGroup = GroupService.findGroup(groupid);
			if(myGroup != null) {
				String res = myGroup.getName();
				return res;
			}
			else {
				log.error("PortalGroupManager::getGroupDisplayName() : Groupe " + groupid + " inexistant");
				throw new GroupException("Groupe " + groupid + " inexistant");
			}
		}
		catch(GroupsException e) {
			log.error("PortalGroupManager::isMemberOf() : Erreur d'acc\u00E8s aux groupes");
			log.error("PortalGroupManager::isMemberOf() : GroupsException " + e);
			throw new GroupException("Erreur d'acc\u00E8s aux groupes");
		}
	}
	
	/**
	 * Indique si un utilisateur est membre d'un groupe
	 * @param userid L'identifiant de l'utilisateur
	 * @param group L'identifiant du groupe
	 * @return true si l'utilisateur est membre, false sinon
	 * @throws GroupException
	 */
	public synchronized boolean isMemberOf(String userid, String group) throws GroupException {
	    if(log.isDebugEnabled()) {
		    log.debug("PortalGroupManager::isMemberOf() : user : " + userid + " group : " + group);
	    }
		IEntity user = null;
		try {
			user = GroupService.getEntity(userid, org.jasig.portal.security.IPerson.class);
			if(user != null) {
				Iterator i = user.getAllContainingGroups();
				while(i.hasNext()) {
					IGroupMember tmp = (IGroupMember)i.next();
					if(tmp.getKey().equals(group)) {
						return true;
					}
				}
				return false;
			}
			else {
				log.error("PortalGroupManager::isMemberOf() : Utilisateur " + userid + " inexistant");
				throw new GroupException("Utilisateur " + userid + " inexistant");
			}
		}
		catch(GroupsException e) {
			log.error("PortalGroupManager::isMemberOf() : Erreur d'acc\u00E8s aux groupes");
			log.error("PortalGroupManager::isMemberOf() : " + e);
			throw new GroupException("Erreur d'acc\u00E8s aux groupes");
		}
	}
	
	/**
	 * Indique si un utilisateur est membre d'un des groupes d'une liste
	 * @param userid L'identifiant de l'utilisateur
	 * @param groups La liste des identifiants de groupe
	 * @return true si l'utilisateur est membre d'au moins un des groupes , false sinon
	 * @throws GroupException
	 */
	public synchronized boolean isMemberOf(String userid, Collection groups) throws GroupException {
		Iterator i = groups.iterator();
		while(i.hasNext()) {
			String group = (String)i.next();
			if(log.isDebugEnabled()) {
			    log.debug("PortalGroupManager::isMemberOf() : " + group);
			}
			if(isMemberOf(userid, group)) {
				return true;
			}
		}
		return false;
	}
}
