<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="no" />

<xsl:param name="baseActionURL" />
<xsl:param name="prefForm" />
<xsl:param name="mediaPath" />

<xsl:template match="users">

<script language="javascript" src="{$mediaPath}functions.js" >
</script>

<table border="0" width="100%" cellspacing="0" cellpadding="10">
	<tr class="uportal-background-light">
		<td class="uportal-channel-table-header" nowrap="true">Gestion des Super Utilisateurs</td>
		<td>
			<a href="{$baseActionURL}?action=defaultadmin">
				<img src="{$mediaPath}parentfolder.gif" alt="Retour" border="0" />
			</a>
		</td>
		<td width="100%">&#160;</td>
	</tr>
</table>
<br/>

<form method="post" action="{$baseActionURL}">
<input type="hidden" name="action" value="addsu" />
<table border="0" width="100%">
	<tr>
		<td class="uportal-label" nowrap="true">Login : </td>
		<td><input class="uportal-input-text" type="text" name="login" /></td>
		<td><input class="uportal-button" type="submit" value="Ajouter" name="butadd" /></td>
		<td width="100%">&#160;</td>
	</tr>
</table>
</form>
<br/>
<table border="0" width="100%" cellpadding="5" cellspacing="0">
	<tr class="uportal-background-highlight">
		<td class="uportal-channel-table-header" nowrap="true">Login</td>
		<td width="5%">&#160;</td>
		<td class="uportal-channel-table-header" nowrap="true">Nom</td>
		<td width="5%">&#160;</td>
		<td class="uportal-channel-table-header" nowrap="true">Supprimer</td>
		<td width="100%">&#160;</td>
	</tr>
	<xsl:apply-templates select="user" />
</table>

</xsl:template>

<xsl:template match="user">
	<tr onmouseover="setPointer(this, 'over', 'uportal-background-light', 'BODY');" onmouseout="setPointer(this, 'out', 'uportal-background-light', 'BODY');">
		<td class="uportal-label" nowrap="true"><xsl:value-of select="./@login" /></td>
		<td width="5%">&#160;</td>
		<td class="uportal-text-small" nowrap="true"><xsl:value-of select="./@displayname" /></td>
		<td width="5%">&#160;</td>
		<td valign="absmiddle">
			<a href="{$baseActionURL}?action=delsu&amp;login={./@login}">
				<img src="{$mediaPath}deletefold.gif" alt="Supprimer" border="0" />
			</a>
		</td>
		<td width="100%">&#160;</td>
	</tr>
</xsl:template>

</xsl:stylesheet>