<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="no" />

<xsl:param name="baseActionURL" />
<xsl:param name="baseDownloadURL" />
<xsl:param name="prefForm" />
<xsl:param name="mediaPath" />
<xsl:param name="role" />
<xsl:param name="folderid" />

<xsl:template match="document">
	<table border="0" width="100%" cellpadding="5" cellspacing="0">
		<tr class="uportal-background-light">
			<td class="uportal-channel-table-header" nowrap="true" >Détails du document</td>
			<td width="5%">&#160;</td>
			<td valign="absmiddle">
				<a href="{$baseActionURL}?action=viewfolder&amp;folderid={$folderid}">
					<img src="{$mediaPath}parentfolder.gif" border="0" alt="Retour"/>
				</a>
			</td>
			<td nowrap="true" class="uportal-label">
				<a href="{$baseActionURL}?action=viewfolder&amp;folderid={$folderid}">
					Retour
				</a>
			</td>
			<xsl:if test="$role='validator'">
				<td valign="absmiddle">
					<a href="{$baseActionURL}?action=invalidate&amp;folderid={$folderid}&amp;id={./@id}">
						<img src="{$mediaPath}invalid.gif" border="0" alt="Invalider"/>
					</a>
				</td>
				<td nowrap="true" class="uportal-label">
					<a href="{$baseActionURL}?action=invalidate&amp;folderid={$folderid}&amp;id={./@id}">
						Invalider
					</a>
				</td>
			</xsl:if>
			<td width="100%">&#160;</td>
		</tr>
	</table>
	<br/>
	<br/>

	<table border="0" width="100%">
		<tr>
			<td class="uportal-channel-strong" nowrap="true">Nom :</td>
			<td width="5%">&#160;</td>
			<td class="uportal-channel-text" nowrap="true">
				<xsl:choose>
					<xsl:when test="./@type='file'">
						<a href="{$baseDownloadURL}?action=download&amp;folderid={./@folder}&amp;id={./@id}">
							<xsl:value-of select="./@file" />
						</a>
					</xsl:when>
					<xsl:otherwise>
						<a href="{./@file}" target="_blank">
							<xsl:value-of select="./@name" /> - <xsl:value-of select="./@file"/>
						</a>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td width="100%">&#160;</td>
		</tr>
		<tr>
			<td class="uportal-channel-strong" nowrap="true">Description :</td>
			<td width="5%">&#160;</td>
			<td class="uportal-channel-text" nowrap="true"><xsl:value-of select="./@description" /></td>
			<td width="100%">&#160;</td>
		</tr>
		<tr>
			<td class="uportal-channel-strong" nowrap="true">Auteur :</td>
			<td width="5%">&#160;</td>
			<td class="uportal-channel-text" nowrap="true"><xsl:value-of select="./@author" /></td>
			<td width="100%">&#160;</td>
		</tr>
		<tr>
			<td class="uportal-channel-strong" nowrap="true">Date de dépôt ou de modification :</td>
			<td width="5%">&#160;</td>
			<td class="uportal-channel-text" nowrap="true"><xsl:value-of select="./@modificationdate" /></td>
			<td width="100%">&#160;</td>
		</tr>
	</table>
</xsl:template>

</xsl:stylesheet>