<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="no" />

<xsl:param name="baseActionURL" />
<xsl:param name="prefForm" />
<xsl:param name="mediaPath" />
<xsl:param name="folderid" />

<xsl:template match="xml">

<script language="javascript" src="{$mediaPath}functions.js" >
</script>

<table border="0" width="100%" cellspacing="0" cellpadding="10">
	<tr class="uportal-background-light">
		<td class="uportal-channel-table-header" nowrap="true">Permissions</td>
		<td>
			<a href="{$baseActionURL}?action=viewfolder&amp;folderid={$folderid}">
				<img src="{$mediaPath}parentfolder.gif" alt="Retour" border="0" />
			</a>
		</td>
		<td width="100%">&#160;</td>
	</tr>
</table>
<br/>
<br/>
<table border="0" width="100%" cellpadding="5" cellspacing="0">
	<tr class="uportal-background-highlight">
		<td class="uportal-channel-table-caption" width="50%">Valideurs</td>
		<td class="uportal-channel-table-caption" width="50%">Publicateurs</td>
	</tr>
	<tr valign="top">
		<form method="post" action="{$baseActionURL}">
		<input type="hidden" name="action" value="modvalidators" />
		<td>
			<table border="0" width="100%" cellpadding="5" cellspacing="0">
				<tr class="uportal-background-med">
					<td>&#160;</td>
					<td class="uportal-channel-table-caption" nowrap="true">Nom</td>
					<!--<td class="uportal-channel-table-caption" nowrap="true">Notifier</td>-->
					<td class="uportal-channel-table-caption" nowrap="true">Supprimer</td>
					<td width="100%">&#160;</td>
				</tr>
				
					<xsl:apply-templates select="validators/user" />						
				
			</table>
			<br/>
			<input type="submit" class="uportal-button" name="butadd" value="Ajouter"/><input type="submit" class="uportal-button" name="butsuppr" value="Supprimer" />
		</td>
		</form>
		
		<form method="post" action="{$baseActionURL}">
		<input type="hidden" name="action" value="modpublicators" />
		<td>
			<table border="0" width="100%" cellpadding="5" cellspacing="0">
				<tr class="uportal-background-med">
					<td>&#160;</td>
					<td class="uportal-channel-table-caption" nowrap="true">Nom</td>
					<td class="uportal-channel-table-caption" nowrap="true">Supprimer</td>
					<td width="100%">&#160;</td>
				</tr>
				
				<xsl:apply-templates select="publicators/groups/group"/>
				
				<xsl:apply-templates select="publicators/users/user"/>
				
			</table>
			<br/>
			<input type="submit" class="uportal-button" name="butadd" value="Ajouter"/><input type="submit" class="uportal-button" name="butsuppr" value="Supprimer" />
		</td>
		</form>
	</tr>
</table>

</xsl:template>

<xsl:template match="validators/user">
	<tr onmouseover="setPointer(this, 'over', 'uportal-background-light', 'BODY');" onmouseout="setPointer(this, 'out', 'uportal-background-light', 'BODY');">
		<td><img src="{$mediaPath}user.gif" border="0" /></td>
		<td class="uportal-channel-text" nowrap="true"><xsl:value-of select="./@displayname" /></td>
		<td align="center" valign="absmiddle"><input type="checkbox" name="uid" value="{./@login}"/></td>
		<!--<td align="center" valign="absmiddle"><input type="checkbox" /></td>-->
		<td width="100%">&#160;</td>
	</tr>
</xsl:template>

<xsl:template match="publicators/groups/group">
	<tr onmouseover="setPointer(this, 'over', 'uportal-background-light', 'BODY');" onmouseout="setPointer(this, 'out', 'uportal-background-light', 'BODY');">
		<td><img src="{$mediaPath}group.gif" border="0" /></td>
		<td class="uportal-channel-text" nowrap="true"><xsl:value-of select="./@name" /></td>
		<td align="center" valign="absmiddle"><input type="checkbox" name="gid" value="{./@id}"/></td>
		<td width="100%">&#160;</td>
	</tr>
</xsl:template>

<xsl:template match="publicators/users/user">
	<tr onmouseover="setPointer(this, 'over', 'uportal-background-light', 'BODY');" onmouseout="setPointer(this, 'out', 'uportal-background-light', 'BODY');">
		<td><img src="{$mediaPath}user.gif" border="0" /></td>
		<td class="uportal-channel-text" nowrap="true"><xsl:value-of select="./@displayname" /></td>
		<td align="center" valign="absmiddle"><input type="checkbox" name="uid" value="{./@login}"/></td>
		<td width="100%">&#160;</td>
	</tr>
</xsl:template>

</xsl:stylesheet>