<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="no" />

<xsl:param name="baseActionURL"></xsl:param>
<xsl:param name="prefForm"></xsl:param>
<xsl:param name="mediaPath"></xsl:param>

<xsl:template match="xml">

	<table border="0" width="100%" cellspacing="0" cellpadding="10">
		<tr class="uportal-background-light">
			<td class="uportal-channel-table-header" nowrap="true">Plan de l'intranet</td>
			<td>
				<a href="{$baseActionURL}?action=viewfolder&amp;folderid={./folder/@id}">
					<img src="{$mediaPath}parentfolder.gif" border="0" alt="Retour" />
				</a>
			</td>
			<td width="100%">&#160;</td>
		</tr>
	</table>
	<br/>
	<table width="100%" border="0" cellpadding="0" cellspacing="0">
		<xsl:apply-templates select="./folder">
			<xsl:sort select="@name" order="ascending" />
		</xsl:apply-templates>
	</table>
			
</xsl:template>

<xsl:template match="folder">
	<tr>
		<td>&#160;</td>
		<td nowrap="true">
			<table width="100%" border="0" cellpadding="0" cellspacing="0">
				<tr>
					<td align="center" valign="absmiddle" width="20">
						<a href="{$baseActionURL}?action=viewfolder&amp;folderid={./@id}">
							<img src="{$mediaPath}folder.gif" border="0" />
						</a>
					</td>
					<td class="uportal-label" nowrap="true">
						<a href="{$baseActionURL}?action=viewfolder&amp;folderid={./@id}">
							<xsl:value-of select="./@name" />
						</a>
					</td>
					<xsl:if test="count(./folder)!=0">
						<td>&#160;</td>
					</xsl:if>
				</tr>
				<xsl:apply-templates select="./folder">
					<xsl:sort select="@name" order="ascending" />
				</xsl:apply-templates>
			</table>
		</td>
		<td width="100%">&#160;</td>
	</tr>			
</xsl:template>

</xsl:stylesheet>