package org.esupportail.portal.channels.CIntranet;

import org.esupportail.portal.channels.CAnnuaire.CAnnuaireServant;
import org.esupportail.portal.channels.CIntranet.config.Config;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Confirm;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.jasig.portal.IServant;
import org.jasig.portal.PortalException;

/**
 * CAdminIntranet<br>
 * <br>
 * Channel principale du canal d'administration des intranets<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.1
 * 
 */

public class CAdminIntranet extends MainChannel {
        
    /**
     * Constructeur
     * @throws PortalException
     */
    public CAdminIntranet() throws PortalException {
        super();
		setConfigActions(Config.getInstance());
		Message.register(this);
		Confirm.register(this);
		setDefaultAction("defaultadmin");
    }
    
	/**
	 * Mthode appele lors de l'appel  un canal servant<br>
	 * permettant de fixer des paramtres pour ce canal
	 */
	public void initServant(IServant servant) throws PortalException {
		if(servant instanceof CAnnuaireServant) {
		    staticData.setParameter("serverView", Config.getInstance().getAnnuaires());
			staticData.setParameter("returnServant","single");
		}
		super.initServant(servant);
	}
}
