package org.esupportail.portal.channels.CIntranet.actions.admin;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CAnnuaire.Personne;
import org.esupportail.portal.channels.CIntranet.beans.Population;
import org.esupportail.portal.channels.CIntranet.beans.User;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataControler;
import org.esupportail.portal.utils.Groups;
import org.esupportail.portal.utils.Users;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Confirm;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.utils.XMLEscaper;

/**
 * ManagePopulation<br>
 * <br>
 * Cette action prend en charge toutes les manipulations concernant<br>
 * l'ajout d'utilisateurs ou de groupes  la population d'un intranet<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.1
 * 
 */
public class ManagePopulation extends AdminAction {

    protected static final Log log = LogFactory.getLog(ManagePopulation.class);
    
    private String intranet = null;
    private Population population = null;
    private Hashtable groups = null;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public ManagePopulation(MainChannel mainChannel) {
        super(mainChannel);
    }

    /**
	 * Mthode appele si l'utilisateur est un super-utilisateur
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 */
    public Boolean action() throws PortalException, FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("ManagePopulation::action()");
        }
        
        // Rcupration paramtres
        intranet = runtimeData.getParameter("id");
        
        // Tentative d'accs sans paramtre
        if(intranet == null) {
            log.error("ManagePopulation::action() : Erreur d'acc\u00E8s \u00E0 la page");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "defaultadmin");		
			return Boolean.FALSE;
        }
        
        // Rcupration IDataReadManager
        IDataControler data = DataFactory.make();
		
		// Rcupration population
		try {
		    population = data.getPopulation(intranet);
		}
		catch(DataException e) {
		    log.error("ManagePopulation::action() : DataException : " + e);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "defaultadmin");
			return Boolean.FALSE;
		}
		
		// Rcupration des noms de groupes et d'utilisateurs
		groups = new Hashtable();
		Iterator i = population.getGroups().iterator();
		while(i.hasNext()) {
		    String tmp = (String)i.next();
		    try {
		        String name = Groups.getGroupName(tmp);
		        groups.put(tmp, name);
		    }
		    catch(GroupsException e) {
		        log.error("ManagePopulation::action() : " + e);
		    }
		}
		
		i = population.getUsers().iterator();
		while(i.hasNext()) {
		    User tmp = (User)i.next();
		    tmp.setDisplayName(Users.getUserDisplayName(tmp.getLogin()));
		}
        
        return Boolean.TRUE;
    }
    
    /**
     * Affiche la population de l'intranet
     * @return Boolean.TRUE
     */
    public Boolean setXML() throws FrameWorkException {
        StringBuffer xml = new StringBuffer();
        xml.append("<population>\n");
        xml.append("<groups>\n");
        Enumeration e = groups.keys();
        while(e.hasMoreElements()) {
            String tmp = (String)e.nextElement();
            xml.append("<group id=\"" + tmp + "\" name=\"" + XMLEscaper.escape((String)groups.get(tmp)) + "\" />\n");
        }
        xml.append("</groups>\n");
        
        xml.append("<users>\n");
        Iterator i = population.getUsers().iterator();
        while(i.hasNext()) {
            User tmp = (User)i.next();
            xml.append(tmp.toXMLString());
        }
        xml.append("</users>\n");
        xml.append("</population>");
        this.xml = xml.toString();
        return Boolean.TRUE;
    }

    /**
     * Traite l'ajout d'un utilisateur
     * @param rd
     * @return Boolean.FALSE (pas d'affichage)
     */
    public Boolean userinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        runtimeData = rd;
        if(log.isDebugEnabled()) {
            log.debug("ManagePopulation::userinit()");
        }
        
        // Rcupration rsultats servant
		Object [] result = mainChannel.getServantResults();
		if(result == null || result.length != 1) {
		    runtimeData.setParameter("id", intranet);
			mainChannel.redirect(runtimeData, "population");
			return Boolean.FALSE;
		}
		Personne selected = (Personne)result[0];
        
        // Rcupration IDataControler
		IDataControler data = DataFactory.make();
		
		User user = new User();
		user.setLogin(selected.getIdentifiant());
		if(!population.getUsers().contains(user)) {
		    Vector newusers = new Vector();
		    newusers.add(user);
		    Population pop = new Population();
		    pop.setIntranet(intranet);
		    pop.setUsers(newusers);
		    pop.setGroups(new Vector());
		    try {
		        data.addPopulation(pop);
		    }
		    catch(DataException e) {
		        log.error("ManagePopulation::userinit() : DataException : " + e);
		        Hashtable parameters = new Hashtable();
		        parameters.put("id", intranet);
				Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "population", parameters);
				return Boolean.FALSE;
		    }
		}
		runtimeData.setParameter("id", intranet);
        mainChannel.redirect(runtimeData, "population");
        return Boolean.FALSE;
    }
    
    /**
     * Traite l'ajout d'un groupe
     * @param rd
     * @return Boolean.FALSE (pas d'affichage)
     */
    public Boolean groupinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        runtimeData = rd;
        if(log.isDebugEnabled()) {
            log.debug("ManagePopulation::groupinit()");
        }
        
        // Rcupration rsultats servant
		Object [] result = mainChannel.getServantResults();
		if(result == null || result.length == 0) {
		    runtimeData.setParameter("id", intranet);
		    mainChannel.redirect(runtimeData, "population");
			return Boolean.FALSE;
		}
        
        // Rcupration IDataControler
		IDataControler data = DataFactory.make();
		
		Population pop = new Population();
		pop.setIntranet(intranet);
		Vector newgroups = new Vector();
		
		for(int i=0;i<result.length;i++) {
		    IGroupMember tmp = (IGroupMember)result[i];
		    String id = tmp.getKey();
		    if(!groups.containsKey(id)) {
		        newgroups.add(id);
		    }
		}
		
		if(newgroups.size() > 0) {
		    pop.setGroups(newgroups);
		    pop.setUsers(new Vector());
		    try {
		        data.addPopulation(pop);
		    }
		    catch(DataException e) {
		        log.error("ManagePopulation::groupinit() : DataException : " + e);
		        Hashtable parameters = new Hashtable();
		        parameters.put("id", intranet);
				Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "population", parameters);
				return Boolean.FALSE;
		    }
		}
		runtimeData.setParameter("id", intranet);
        mainChannel.redirect(runtimeData, "population");
        return Boolean.FALSE;
    }

    /**
     * Traite la suppression d'un utilisateur
     * @param rd
     * @return Boolean.FALSE (pas d'affichage)
     */
    public Boolean deluserinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        runtimeData = rd;
        if(log.isDebugEnabled()) {
            log.debug("ManagePopulation::deluserinit()");
        }
        
        // Rcupration des paramtres dynamiques
        String user = runtimeData.getParameter("user");
        
        // Vrification des paramtres
        if(user == null) {
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"));
			return Boolean.FALSE;
        }
        
        Hashtable parametersYes = new Hashtable();
        parametersYes.put("user", user);
        Hashtable parametersNo = new Hashtable();
        parametersNo.put("id", intranet);
        Confirm.confirm(mainChannel, runtimeData, "Voulez-vous r\u00E9ellement supprimer cet utilisateur ? Il sera n\u00E9cessaire de le supprimer manuellement des valideurs et des publicateurs des diff\u00E9rents dossiers de cet intranet.", "deluserpop", "population", parametersYes, parametersNo);
        return Boolean.FALSE;
    }
    
    /**
     * Traite la suppression d'un groupe
     * @param rd
     * @return Boolean.FALSE (pas d'affichage)
     */
    public Boolean delgroupinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        runtimeData = rd;
        if(log.isDebugEnabled()) {
            log.debug("ManagePopulation::delgroupinit()");
        }
        
        // Rcupration des paramtres dynamiques
        String group = runtimeData.getParameter("groupid");
        
        // Vrification des paramtres
        if(group == null) {
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"));
			return Boolean.FALSE;
        }
        
        Hashtable parametersYes = new Hashtable();
        parametersYes.put("group", group);
        Hashtable parametersNo = new Hashtable();
        parametersNo.put("id", intranet);
        Confirm.confirm(mainChannel, runtimeData, "Voulez-vous r\u00E9ellement supprimer ce groupe ? Il sera n\u00E9cessaire de le supprimer manuellement des publicateurs des diff\u00E9rents dossiers de cet intranet.", "delgrouppop", "population", parametersYes, parametersNo);
        return Boolean.FALSE;
    }

    /**
     * Traite la suppression d'un utilisateur
     * @param rd
     * @return Boolean.FALSE (pas d'affichage)
     */
    public Boolean deluser(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        runtimeData = rd;
        if(log.isDebugEnabled()) {
            log.debug("ManagePopulation::deluser()");
        }
        
        // Rcupration des paramtres dynamiques
        String user = runtimeData.getParameter("user");
        
        // Traitement
        IDataControler data = DataFactory.make();
        try {
            data.removeUserFromPopulation(user, intranet);
        }
        catch(DataException e) {
            log.error("ManagePopulation::deluser() : DataException : " + e);
	        Hashtable parameters = new Hashtable();
	        parameters.put("id", intranet);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "population", parameters);
			return Boolean.FALSE;
        }
        
        runtimeData.setParameter("id", intranet);
        mainChannel.redirect(runtimeData, "population");
        return Boolean.FALSE;
    }
    
    /**
     * Traite la suppression d'un groupe
     * @param rd
     * @return Boolean.FALSE (pas d'affichage)
     */
    public Boolean delgroup(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        runtimeData = rd;
        if(log.isDebugEnabled()) {
            log.debug("ManagePopulation::delgroup()");
        }
        
        // Rcupration des paramtres dynamiques
        String group = runtimeData.getParameter("group");
        
        // Traitement
        IDataControler data = DataFactory.make();
        try {
            data.removeGroupFromPopulation(group, intranet);
        }
        catch(DataException e) {
            log.error("ManagePopulation::delgroup() : DataException : " + e);
	        Hashtable parameters = new Hashtable();
	        parameters.put("id", intranet);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "population", parameters);
			return Boolean.FALSE;
        }
        
        runtimeData.setParameter("id", intranet);
        mainChannel.redirect(runtimeData, "population");
        return Boolean.FALSE;
    }

}
