package org.esupportail.portal.channels.CIntranet.actions.admin;

import java.util.Collection;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.User;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataControler;
import org.esupportail.portal.utils.Users;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * SuperUsers<br>
 * <br>
 * Cette action prend en charge l'affichage de la liste des supers utilisateurs<br>
 * et l'ajout de nouveaux utilisateurs<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.1
 * 
 */
public class SuperUsers extends AdminAction {

    protected static final Log log = LogFactory.getLog(SuperUsers.class);
    
    private Collection superusers = null;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public SuperUsers(MainChannel mainChannel) {
        super(mainChannel);
    }
    
    /**
	 * Mthode appele si l'utilisateur est un super-utilisateur
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 */
    public Boolean action() throws PortalException, FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("SuperUsers::action()");
        }
        
        // Rcupration IDataReadManager
        IDataControler data = DataFactory.make();
        
        // Rcupration Super Utilisateurs
        try {
            superusers = data.getSuperUsers();
        }
        catch(DataException e) {
            log.error("SuperUsers::action() : " + e);
            Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "defaultadmin");
            return Boolean.FALSE;
        }
        
        // Rcupration displaynames
        Iterator i = superusers.iterator();
        while(i.hasNext()) {
            User tmp = (User)i.next();
            tmp.setDisplayName(Users.getUserDisplayName(tmp.getLogin()));
        }
        return Boolean.TRUE;
    }

    
    /**
     * Affiche la liste des Super Utilisateurs
     * @return Boolean.TRUE
     */
    public Boolean setXML() throws FrameWorkException {
        StringBuffer xml = new StringBuffer();
        xml.append("<users>\n");
        Iterator i = superusers.iterator();
        while(i.hasNext()) {
            User tmp = (User)i.next();
            xml.append(tmp.toXMLString());
        }
        xml.append("</users>");
        this.xml = xml.toString();
        return Boolean.TRUE;
    }

    /**
     * Suppression d'un Super Utilisateur
     * @param rd
     * @return Boolean.FALSE (pas d'affichage)
     */
    public Boolean delinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        runtimeData = rd;
        if(log.isDebugEnabled()) {
            log.debug("SuperUsers::delinit()");
        }
        
        // Rcupration paramtres
        String login = runtimeData.getParameter("login");
        
        // Tentative d'accs sans paramtre
        if(login == null) {
            Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'accs  la page"), "defaultadmin");
            return Boolean.FALSE;
        }
        
        // Rcupration IDataControler
        IDataControler data = DataFactory.make();
        
        // Suppression du Super Utilisateur
        try {
            data.removeSuperUser(login);
        }
        catch(DataException e) {
            log.error("SuperUsers::delinit() : " + e);
            Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "defaultadmin");
            return Boolean.FALSE;
        }
        mainChannel.redirect(runtimeData, "su");        
        return Boolean.FALSE;
    }
    
    /**
     * Ajout d'un type MIME
     * @param rd
     * @return Boolean.FALSE (pas d'affichage)
     */
    public Boolean addinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        runtimeData = rd;
        if(log.isDebugEnabled()) {
            log.debug("SuperUsers::addinit()");
        }
        
        // Rcupration paramtres
        String login = runtimeData.getParameter("login");
        
        // Tentative d'accs sans paramtre
        if(login == null) {
            Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'accs  la page"), "defaultadmin");
            return Boolean.FALSE;
        }
        
        // Rcupration IDataControler
        IDataControler data = DataFactory.make();
        
        // Ajout du Super Utilisateur
        try {
            data.addSuperUser(login);
        }
        catch(DataException e) {
            log.error("SuperUsers::addinit() : " + e);
            Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "defaultadmin");
            return Boolean.FALSE;
        }
        mainChannel.redirect(runtimeData, "su");        
        return Boolean.FALSE;
    }
}
