package org.esupportail.portal.channels.CIntranet.actions.intranet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.security.ISecurityManager;
import org.esupportail.portal.channels.CIntranet.security.SecurityException;
import org.esupportail.portal.channels.CIntranet.security.SecurityFactory;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.jasig.portal.security.IPerson;

/**
 * IntranetAction<br>
 * <br>
 * Classe abstraite dfinissant un comportement par dfaut pour une action<br>
 * L'accs  cette action ncessite un niveau d'accrditation dfini par la mthode<br>
 * getLevel() sinon l'utilisateur est redirig vers une page d'erreur<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */

public abstract class IntranetAction extends SubChannel {

    protected static final Log log = LogFactory.getLog(IntranetAction.class);
    
    protected String folderid = null;
	protected String intranet = null;
	protected String login = null;
	protected String ressource = null;
	protected boolean superuser = false;
	protected int role = -1;
	
	/**
	 * Constructeur
	 * @param mainChannel Channel principale
	 */
	public IntranetAction(MainChannel mainChannel) {
		super(mainChannel);
	}
	
	/**
	 * Mthode vrifiant le niveau d'accrditation de l'utilisateur courant
	 * @param rd
	 * @return Boolean.FALSE si le niveau est insuffisant, action() sinon
	 */
	public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		if(log.isDebugEnabled()) {
		    log.debug("IntranetAction::init()");
		}
		runtimeData = rd;
		
		// Rcupration paramtres statiques
		login = mainChannel.getStaticData().getPerson().getAttribute(IPerson.USERNAME).toString();
		intranet = (String)mainChannel.getStaticData().get("intranet");
		ressource = (String)mainChannel.getStaticData().get("ressource");
		
		// Rcupration paramtres runtime
		folderid = runtimeData.getParameter("folderid");
		if(intranet == null) {
			intranet = runtimeData.getParameter("intranet");
			if(intranet == null) {
				log.error("IntranetAction::init() : intranet = null");
				Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "default");
				return Boolean.FALSE;
			}
			else {
				mainChannel.getStaticData().put("intranet", intranet);
			}
		}
		if(ressource == null) {
			ressource = runtimeData.getParameter("ressource");
			if(ressource == null) {
				log.error("IntranetAction::init() : ressource = null");
				Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "default");
				return Boolean.FALSE;
			}
			else {
				mainChannel.getStaticData().put("ressource", ressource);
			}
		}
		
		// Rcupration niveau d'accrditation
		int level = getLevel();
		
		// Vrification paramtres
		if(folderid == null || login == null) {
			log.error("IntranetAction::init() : folderid = null || login = null");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "default");
			return Boolean.FALSE;
		}
		
		// Rcupration ISecurityManager
		ISecurityManager security = SecurityFactory.make();
		if(security == null) {
			log.error("IntranetAction::init() : security = null");
			Message.message(mainChannel, runtimeData, new MessageBean("Impossible d'acc\u00E9der au service de s\u00E9curit\u00E9"));
			return Boolean.FALSE;
		}
		// Vrification accs
		try {
			superuser = security.isSuperUser(login);
			if(!superuser) {
				if(!security.isIntranetAccessible(intranet, login)) {
					log.error("IntranetAction::init() : Acc\u00E8s refus\u00E9 " + intranet + " pour " + login);
					Message.message(mainChannel, runtimeData, new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 acc\u00E9der \u00E0 cette page"), "default");
					return Boolean.FALSE;
				}
				else {
					// Role de l'utilisateur
					this.role = security.getRoleOfUser(folderid, login);
				}
			}
		}
		catch(SecurityException e) {
			log.error("IntranetAction::init() : SecurityException : " + e);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()));
			return Boolean.FALSE;
		}
		
		if(!superuser && this.role < level) {
			log.error("IntranetAction::init() : Niveau d'accrditation insuffisant");
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "default");
			return Boolean.FALSE;
		}
		
		// Transfert  la classe d'implmentation
		return action();
	}
	
	/**
	 * Mthode abstraite implmentant le comportement de l'action lorsque le niveau d'accrditation<br>
	 * est suffisant
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public abstract Boolean action() throws PortalException, FrameWorkException;
	
	/**
	 * Mthode abstraite dfinissant le niveau d'accrditation ncessaire pour cette action<br>
	 * ISecurityManager.USER, ISecurityManager.PUBLICATOR, ISecurityManager.VALIDATOR
	 * @return Le niveau d'accrditation minimum
	 */
	public abstract int getLevel();
}
