package org.esupportail.portal.channels.CIntranet.actions.intranet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * Multiple<br>
 * <br>
 * Cette action prend en charge la traitements multiples sur les documents<br>
 * Elle redirige vers les actions de suppression multiple ou de validation multiple<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.1
 * 
 */

public class Multiple extends SubChannel {

    protected static final Log log = LogFactory.getLog(Multiple.class);
    
    /**
	 * Constructeur
	 * @param mainChannel Channel principale
	 */
	public Multiple(MainChannel mainChannel) {
		super(mainChannel);
	}
	
	/**
	 * Dtermine l'action  effectuer et redirige
	 * @param rd
	 * @return Boolean.FALSE (pas d'affichage)
	 */
	public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		runtimeData = rd;
		if(log.isDebugEnabled()) {
		    log.debug("Multiple::init()");
		}
		
		// Rcupration paramtres
		String target = runtimeData.getParameter("target");
		
		// Tentative d'accs sans paramtre
		if(target == null) {
		    mainChannel.redirect(runtimeData, "viewfolder");
			return Boolean.FALSE;
		}
		
		// Suppression multiple
		if(target.equals("delete")) {
		    mainChannel.redirect(runtimeData, "deletedocs");
			return Boolean.FALSE;
		}
		
		// Validation multiple
		if(target.equals("validate")) {
		    mainChannel.redirect(runtimeData, "confval");
		    return Boolean.FALSE;
		}
		
		// Erreur d'accs
		mainChannel.redirect(runtimeData, "viewfolder");
		return Boolean.FALSE;
	}
}
