package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.beans.Folder;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataControler;
import org.esupportail.portal.channels.CIntranet.security.ISecurityManager;
import org.esupportail.portal.channels.CIntranet.storage.IStorageControler;
import org.esupportail.portal.channels.CIntranet.storage.StorageException;
import org.esupportail.portal.channels.CIntranet.storage.StorageFactory;
import org.esupportail.portal.channels.CIntranet.utils.Date;
import org.esupportail.portal.channels.CIntranet.utils.SizeLimitException;
import org.esupportail.portal.channels.CIntranet.utils.UploadWorker;
import org.esupportail.portal.utils.channels.Action;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * NewDocument<br>
 * <br>
 * Cette action prend en charge la cration d'un nouveau document<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.1
 * 
 */

public class NewDocument extends IntranetAction {

    protected static final Log log = LogFactory.getLog(NewDocument.class);
    
    private Folder dossier = null;
	private int type = 0;
	
	/**
	 * Constructeur
	 * @param mainChannel Channel principale
	 */
	public NewDocument(MainChannel mainChannel) {
		super(mainChannel);
	}

	/**
	 * Retourne le niveau d'accrditation minimum pour accder  cette action
	 * @return ISecurityManager.PUBLICATOR
	 */
	public int getLevel() {
		return ISecurityManager.PUBLICATOR;
	}

	/**
	 * Mthode appele si la personne a le niveau requis
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon 
	 */
	public Boolean action() throws PortalException, FrameWorkException {
		if(log.isDebugEnabled()) {
		    log.debug("NewDocument::action()");
		}
		
		// Rcupration IDataControler
		IDataControler data = DataFactory.make();

		// Rcupration Dossier
		try {
			dossier = data.getFolder(folderid, false);
		}
		catch(DataException e) {
			log.error("NewDocument::action() : DataException : " + e);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");
			return Boolean.FALSE;
		}
		return Boolean.TRUE;
	}
	
	/**
	 * Affichage du formulaire cration d'un lien ou d'un fichier
	 * @return Boolean.TRUE
	 */
	public Boolean setXML() {
	    this.xml = "";
	    xslParameters.put("folderid", folderid);
		return Boolean.TRUE;
	}
	
	/**
	 * Dtermine le type de document  crer
	 * @param rd
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon 
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean typeinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		if(log.isDebugEnabled()) {
		    log.debug("NewDocument::typeinit()");
		}
		runtimeData = rd;
		
		// Vrification accs
		if(!superuser && role < getLevel()) {
			log.error("NewDocument::typeinit()() : Acc\u00E8s non autoris\u00E9");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration bouton
		String button = runtimeData.getParameter("butsuiv");
	
		// Clic sur le bouton Annuler
		if(button == null) {
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "viewfolder");
			return Boolean.FALSE;
		}
		
		// Rcupration paramtres
		String type = runtimeData.getParameter("type");
		
		// Tentative d'accs sans paramtres
		if(type == null || type.equals("")) {
			log.error("NewDocument::typeinit() : Erreur d'acc\u00E8s \u00E0 la page");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "default");		
			return Boolean.FALSE;
		}
		
		// Type de document
		if(type.equals("file")) {
			this.type = Document.FILE;
		}
		else {
			this.type = Document.LINK;
		}
		return Boolean.TRUE;
	}
	
	/**
	 * Affiche le formulaire de cration de fichier ou de lien suivant le type de document
	 * @return Boolean.TRUE
	 */
	public Boolean typexml() {
		xslParameters.put("folderid", folderid);
	    return Boolean.TRUE;
	}

	/**
	 * Positionnement du titre ssl
	 */
	public void typeoutput() throws FrameWorkException {
		Action current = mainChannel.getCurrentAction();
		setSSL(current.getSslFile());
		if(type == Document.FILE) {
			setXSL("file");
		}
		else {
			setXSL("link");
		}
	}
	
	/**
	 * Cre un nouveau fichier
	 * @param rd
	 * @return Boolean.FALSE (pas d'affichage)
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean fileinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		if(log.isDebugEnabled()) {
		    log.debug("NewDocument::fileinit()");
		}
		runtimeData = rd;
		
		// Vrification accs
		if(!superuser && role < getLevel()) {
			log.error("NewDocument::fileinit() : Acc\u00E8s non autoris\u00E9");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration bouton
		String button = runtimeData.getParameter("butcreer");

		// Clic sur le bouton Annuler
		if(button == null) {
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "viewfolder");
			return Boolean.FALSE;
		}
		
		// Rcupration paramtres
		String description = runtimeData.getParameter("description");
		
		// Tentative d'accs sans paramtres
		if(description == null) {
			log.error("NewDocument::fileinit() : Erreur d'acc\u00E8s \u00E0 la page");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "default");		
			return Boolean.FALSE;
		}
		
		// Vrification validit paramtres
		if(description.equals("")) {
			Hashtable parameters = new Hashtable();
			parameters.put("butsuiv", "Suivant");
			parameters.put("type", "file");
			Message.message(mainChannel, runtimeData, new MessageBean("La description est vide"), "typedoc", parameters);
			return Boolean.FALSE;
		}
		
		UploadWorker worker = new UploadWorker(runtimeData);
		try {
			worker.parseFile("file");
		}
		catch(SizeLimitException e) {
			log.error("NewDocument::fileinit() : Taille de fichier trop importante");
			Hashtable parameters = new Hashtable();
			parameters.put("butsuiv", "Suivant");
			parameters.put("type", "file");
			Message.message(mainChannel, runtimeData, new MessageBean("Le fichier joint est trop gros"), "typedoc", parameters);
			return Boolean.FALSE;
		}
		catch(FileNotFoundException e) {
			log.error("NewDocument::fileinit() : Aucun fichier attach\u00E9");
			Hashtable parameters = new Hashtable();
			parameters.put("butsuiv", "Suivant");
			parameters.put("type", "file");
			Message.message(mainChannel, runtimeData, new MessageBean("Le fichier joint est manquant"), "typedoc", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration du fichier upload
		Document doc = new Document();
		doc.setIntranet(intranet);
		doc.setType(Document.FILE);
		doc.setFile(worker.getName());
		doc.setAuthor(login);
		doc.setModificationDate(Date.getCurrentDate());
		doc.setLimitDate("99991231");
		doc.setDescription(description);
		doc.setLocked(false);
		doc.setFolder(folderid);
		doc.setOrder("0");
		
		String extension = doc.getExtension();
		if(extension == null) {
			log.error("NewDocument::fileinit() : Type de fichier non valide");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Type de fichier non valide : " + extension), "viewfolder");		
			return Boolean.FALSE;
		}
		
		// Rcupration inputstream
		InputStream filestream = null;
		try {
			filestream = worker.getInputStream();
		}
		catch(IOException e) {
			log.error("NewDocument::fileinit() : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Impossible de r\u00E9cup\u00E9rer le fichier joint"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration IDataReadManager
		IDataControler data = DataFactory.make();
		
		boolean valid = false;
		try {
			valid = data.isValidMIME(extension);
		}
		catch(DataException e) {
			log.error("NewDocument::fileinit() : " + e);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()));
			return Boolean.FALSE;
		}
		
		if(!valid) {
			log.error("NewDocument::fileinit() : Mauvais type MIME " + extension);
			Hashtable parameters = new Hashtable();
			parameters.put("butsuiv", "Suivant");
			parameters.put("type", "file");
			Message.message(mainChannel, runtimeData, new MessageBean("Ce type de fichier (" + extension + ") n'est pas valide"), "typedoc", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration IStorageControler
		IStorageControler store = StorageFactory.make(ressource);
		
		// Cration du document
		try {
			if(!superuser && role == ISecurityManager.PUBLICATOR && dossier.isValidation()) {
			    doc.setNew(true);
			    data.createDocument(doc, false);
			}
			else {
				data.createDocument(doc, true);
			}
			store.saveDocument(intranet, doc, filestream);
			data.commit();
		}
		catch(DataException e) {
			log.error("NewDocument::fileinit() : DataException : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		catch(StorageException e) {
			log.error("NewDocument::fileinit() : StorageException : " + e);
			data.rollback();
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		runtimeData.setParameter("folderid", folderid);
		mainChannel.redirect(runtimeData, "viewfolder");
		return Boolean.FALSE;
	}
	
	/**
	 * Cre un nouveau lien
	 * @param rd
	 * @return Boolean.FALSE (pas d'affichage)
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean linkinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		if(log.isDebugEnabled()) {
		    log.debug("NewDocument::linkinit()");
		}
		runtimeData = rd;
		
		// Vrification accs
		if(!superuser && role < getLevel()) {
			log.error("NewDocument::linkinit() : Acc\u00E8s non autoris\u00E9");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration bouton
		String button = runtimeData.getParameter("butcreer");

		// Clic sur le bouton Annuler
		if(button == null) {
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "viewfolder");
			return Boolean.FALSE;
		}
		
		// Rcupration paramtres
		String nom = runtimeData.getParameter("name");
		String description = runtimeData.getParameter("description");
		String url = runtimeData.getParameter("link");
		
		// Tentative d'accs sans paramtres
		if(nom == null || description == null || url == null) {
			log.error("NewDocument::linkinit() : Erreur d'acc\u00E8s \u00E0 la page");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "default");		
			return Boolean.FALSE;
		}
		
		// Vrification validit paramtres
		if(nom.equals("")) {
			Hashtable parameters = new Hashtable();
			parameters.put("butsuiv", "Suivant");
			parameters.put("type", "link");
			Message.message(mainChannel, runtimeData, new MessageBean("Le nom est vide"), "typedoc", parameters);
			return Boolean.FALSE;
		}
		
		if(description.equals("")) {
			Hashtable parameters = new Hashtable();
			parameters.put("butsuiv", "Suivant");
			parameters.put("type", "link");
			Message.message(mainChannel, runtimeData, new MessageBean("La description est vide"), "typedoc", parameters);
			return Boolean.FALSE;
		}
		
		if(url.equals("")) {
			Hashtable parameters = new Hashtable();
			parameters.put("butsuiv", "Suivant");
			parameters.put("type", "link");
			Message.message(mainChannel, runtimeData, new MessageBean("L'adresse est vide"), "typedoc", parameters);
			return Boolean.FALSE;
		}
		
		if(!url.startsWith("http://")) {
			Hashtable parameters = new Hashtable();
			parameters.put("butsuiv", "Suivant");
			parameters.put("type", "link");
			Message.message(mainChannel, runtimeData, new MessageBean("Mauvaise adresse, une adresse valide est du type http://www.exemple.com"), "typedoc", parameters);
			return Boolean.FALSE;
		}
		
		// Cration du document
		Document doc = new Document();
		doc.setIntranet(intranet);
		doc.setType(Document.LINK);
		doc.setName(nom);
		doc.setFile(url);
		doc.setAuthor(login);
		doc.setModificationDate(Date.getCurrentDate());
		doc.setLimitDate("99991231");
		doc.setDescription(description);
		doc.setLocked(false);
		doc.setFolder(folderid);
		doc.setOrder("0");

		// Rcupration IDataControler
		IDataControler data = DataFactory.make();
		
		// Cration du document
		try {
			if(!superuser && role == ISecurityManager.PUBLICATOR && dossier.isValidation()) {
				doc.setNew(true);
			    data.createDocument(doc, false);
			}
			else {
				data.createDocument(doc, true);
			}
			data.commit();
		}
		catch(DataException e) {
			log.error("NewDocument::linkinit() : DataException : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		runtimeData.setParameter("folderid", folderid);
		mainChannel.redirect(runtimeData, "viewfolder");
		return Boolean.FALSE;
	}
}
