package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.Hashtable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Folder;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataControler;
import org.esupportail.portal.channels.CIntranet.security.ISecurityManager;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * NewFolder<br>
 * <br>
 * Cette action prend en charge la cration d'un nouveau dossier<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.1
 * 
 */

public class NewFolder extends IntranetAction {

    protected static final Log log = LogFactory.getLog(NewFolder.class);
    
    private Folder dossier = null;

	/**
	 * Constructeur
	 * @param mainChannel Channel principale
	 */
	public NewFolder(MainChannel mainChannel) {
		super(mainChannel);
	}
	
	/**
	 * Retourne le niveau d'accrditation minimum pour accder  cette action
	 * @return ISecurityManager.PUBLICATOR
	 */
	public int getLevel() {
		return ISecurityManager.PUBLICATOR;
	}
	
	/**
	 * Mthode appele si la personne a le niveau requis
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon 
	 */
	public Boolean action() throws PortalException, FrameWorkException {
		if(log.isDebugEnabled()) {
		    log.debug("NewFolder::action()");
		}
		
		// Rcupration IDataReadManager
		IDataControler data = DataFactory.make();

		// Rcupration Dossier
		try {
			dossier = data.getFolder(folderid, false);
		}
		catch(DataException e) {
			log.error("NewFolder::action() : DataException : " + e);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");
			return Boolean.FALSE;
		}
		
		// Vrification accs
		if(!superuser && role == ISecurityManager.PUBLICATOR && dossier.isValidation()) {
			log.error("NewFolder::action() : Acc\u00E8s non autoris\u00E9");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		return Boolean.TRUE;
	}
	
	/**
	 * Affichage du formulaire de cration de dossier
	 * @return Boolean.TRUE
	 */
	public Boolean setXML() {
		this.xml = dossier.toXMLString();
		xslParameters.put("folderid", folderid);
		return Boolean.TRUE;
	}
	
	/**
	 * Cration du nouveau dossier
	 * @param rd
	 * @return Boolean.FALSE (pas d'affichage)
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean createinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		if(log.isDebugEnabled()) {
		    log.debug("NewFolder::createinit()");
		}
		runtimeData = rd;
		
		// Vrification accs
		if(!superuser && (role < getLevel() || (role == ISecurityManager.PUBLICATOR && dossier.isValidation()))) {
			log.error("NewFolder::createInit() : Acc\u00E8s non autoris\u00E9");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration bouton
		String button = runtimeData.getParameter("butcreer");
		
		// Clic sur le bouton Annuler
		if(button == null) {
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "viewfolder");
			return Boolean.FALSE;
		}
		
		// Rcupration paramtres
		String name = runtimeData.getParameter("name");
		boolean validation = false;
		if(runtimeData.getParameter("valid") != null) {
			validation = true;
		}

		// Tentative d'accs sans paramtres
		if(name == null) {
			log.error("NewFolder::createInit() : Erreur d'acc\u00E8s \u00E0 la page");
			Message.message(mainChannel, runtimeData, new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "default");		
			return Boolean.FALSE;
		}
		
		// Vrification validit paramtres
		if(name.equals("")) {
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Le nom du dossier est vide"), "newfolder", parameters);
			return Boolean.FALSE;
		}
		
		Folder newfold = new Folder();
		newfold.setParent(folderid);
		newfold.setIntranet(intranet);
		newfold.setName(name);
		
		if(!dossier.isValidation()) {
			newfold.setValidation(false);
		}
		else {
			newfold.setValidation(validation);
		}
		
		// Rcupration IDataControler
		IDataControler data = DataFactory.make();

		// Cration du dossier
		try {
			data.createFolder(newfold);
		}
		catch(DataException e) {
			log.error("NewFolder::createinit() : DataException : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		runtimeData.setParameter("folderid", folderid);
		mainChannel.redirect(runtimeData, "viewfolder");
		return Boolean.FALSE;
	}
}
