package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.Hashtable;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataControler;
import org.esupportail.portal.channels.CIntranet.security.ISecurityManager;
import org.esupportail.portal.channels.CIntranet.storage.IStorageControler;
import org.esupportail.portal.channels.CIntranet.storage.StorageException;
import org.esupportail.portal.channels.CIntranet.storage.StorageFactory;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.PortalException;

/**
 * ValidateDocuments<br>
 * <br>
 * Cette action prend en charge la validation de plusieurs documents<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */

public class ValidateDocuments extends IntranetAction {
	
    protected static final Log log = LogFactory.getLog(ValidateDocuments.class);
    
    /**
	 * Constructeur
	 * @param mainChannel Channel principale
	 */
	public ValidateDocuments(MainChannel mainChannel) {
		super(mainChannel);
	}

	/**
	 * Retourne le niveau d'accrditation minimum pour accder  cette action
	 * @return ISecurityManager.VALIDATOR
	 */
	public int getLevel() {
		return ISecurityManager.VALIDATOR;
	}
	
	/**
	 * Mthode appele si la personne a le niveau requis
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon 
	 */
	public Boolean action() throws PortalException, FrameWorkException {
		if(log.isDebugEnabled()) {
		    log.debug("ValidateDocument::action()");
		}
		
		// Rcupration des paramtres
		String [] ids = runtimeData.getParameterValues("id");
		
		// Vrification validit des paramtres
		if(ids == null) {
			// Aucun document slectionn
			// Redirection affichage du dossier
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "viewfolder");
			return Boolean.FALSE;
		}
		
		// Rcupration IDataControler
		IDataControler data = DataFactory.make();
		
		// Rcupration IStorageControler
		IStorageControler store = StorageFactory.make(ressource);
		
		Vector v = new Vector();
		for(int i=0;i<ids.length;i++) {
		
			String id = ids[i];
			Document doc = null;
			// Validation du document
			try {
				doc = data.getDocument(intranet, id);
			}
			catch(DataException e) {
				log.error("ValidateDocument::action() : " + e);
			}
			
			if(doc != null && !doc.isValid()) {
				doc.setId("v" + doc.getId().substring(1));
				try {
					data.validDocument(doc);
					store.validDocument(intranet, doc);
					data.commit();
				}
				catch(DataException e) {
					log.error("ValidateDocument::action() : " + e);
					v.add(new MessageBean(doc.getName() + " : " + e.getMessage(), Message.ERROR));
				}
				catch(StorageException e) {
					log.error("ValidateDocument::action() : " + e);
					data.rollback();
					v.add(new MessageBean(doc.getName() + " : " + e.getMessage(), Message.ERROR));
				}
				v.add(new MessageBean(doc.getName() + " : Document valid\u00E9", Message.INFO));
			}
		}
		
		if(v.size() == 0) {
		    runtimeData.setParameter("folderid", folderid);
		    mainChannel.redirect(runtimeData, "viewfolder");
		    return Boolean.FALSE;
		}
		
		Hashtable parameters = new Hashtable();
		parameters.put("folderid", folderid);
		Message.message(mainChannel, runtimeData, v, "viewfolder", parameters);
		return Boolean.FALSE;
	}
}
