package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.Collection;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Folder;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataControler;
import org.esupportail.portal.channels.CIntranet.security.ISecurityManager;
import org.esupportail.portal.utils.channels.Action;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.PortalException;

/**
 * ViewFolder<br>
 * <br>
 * Cette action prend en charge la visualisation d'un dossier<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.1
 * 
 */

public class ViewFolder extends IntranetAction {

    protected static final Log log = LogFactory.getLog(ViewFolder.class);
    
    private Folder dossier = null;
	private Collection path = null;
	
	/**
	 * Constructeur
	 * @param mainChannel Channel principale
	 */
	public ViewFolder(MainChannel mainChannel) {
		super(mainChannel);
	}
	
	/**
	 * Retourne le niveau d'accrditation minimum pour accder  cette action
	 * @return ISecurityManager.USER
	 */
	public int getLevel() {
		return ISecurityManager.USER;
	}

	/**
	 * Mthode appele si la personne a le niveau requis
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon 
	 */
	public Boolean action() throws PortalException, FrameWorkException {
		if(log.isDebugEnabled()) {
		    log.debug("ViewFolder::action()");
		}
		
		// Rcupration IDataControler
		IDataControler data = DataFactory.make();
		
		// Rcupration Dossier
		try {
			dossier = data.getFolder(folderid, true);
		}
		catch(DataException e) {
			log.error("ViewFolder::action() : DataException : " + e);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");
			return Boolean.FALSE;
		}
		
		// Filtrage des documents
		if(superuser) {
		    dossier.setDocuments(Filters.filterValidator(dossier.getDocuments()));
		}
		else {
		    switch(role) {
		    	case ISecurityManager.VALIDATOR : {
		    	    dossier.setDocuments(Filters.filterValidator(dossier.getDocuments()));
		    	    break;
		    	}
		    	case ISecurityManager.PUBLICATOR : {
		    	    dossier.setDocuments(Filters.filterPublicator(dossier.getDocuments(), login));
		    	    dossier.setDocuments(Filters.filterLimitDates(dossier.getDocuments()));
		    	    break;
		    	}
		    	case ISecurityManager.USER : {
		    	    dossier.setDocuments(Filters.filterUser(dossier.getDocuments()));
		    	    dossier.setDocuments(Filters.filterLimitDates(dossier.getDocuments()));
		    	    break;
		    	}
		    	default : {
		    	    dossier.setDocuments(Filters.filterUser(dossier.getDocuments()));
		    	    dossier.setDocuments(Filters.filterLimitDates(dossier.getDocuments()));
		    	    break;
		    	}
		    }
		}
		dossier.setDocuments(Filters.filterLongNames(dossier.getDocuments()));
		
		return Boolean.TRUE;
	}
	
	/**
	 * Affichage du dossier
	 * @return Boolean.TRUE
	 */
	public Boolean setXML() {
		this.xml = dossier.toXMLString();
		addDownloadXslParameter();
		return Boolean.TRUE;
	}
	
	
    /**
     * Positionnement du titre ssl
     */
    public void setOutput() throws FrameWorkException {
        Action current = mainChannel.getCurrentAction();
		setSSL(current.getSslFile());
		if(superuser) {
			setXSL("validator");
		}
		else {
			switch(role) {
				case ISecurityManager.VALIDATOR : setXSL("validator");;break;
				case ISecurityManager.PUBLICATOR : setXSL("publicator");;break;
				case ISecurityManager.USER : setXSL("user");;break;
				default : setXSL("user");;
			}
		}
    }
}
