package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CAnnuaire.Personne;
import org.esupportail.portal.channels.CIntranet.beans.Population;
import org.esupportail.portal.channels.CIntranet.beans.User;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.data.DataFactory;
import org.esupportail.portal.channels.CIntranet.data.IDataControler;
import org.esupportail.portal.channels.CIntranet.security.ISecurityManager;
import org.esupportail.portal.channels.CIntranet.security.SecurityException;
import org.esupportail.portal.channels.CIntranet.security.SecurityFactory;
import org.esupportail.portal.utils.Groups;
import org.esupportail.portal.utils.Users;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.utils.XMLEscaper;

/**
 * ViewPermissions<br>
 * <br>
 * Cette action prend en charge la visualisation / modification des permissions d'un dossier<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.1
 * 
 */

public class ViewPermissions extends IntranetAction {

    protected static final Log log = LogFactory.getLog(ViewPermissions.class);
    
    private Collection validators = null;
	private Collection users = null;
	private Hashtable groups = null;
	private Hashtable population = null;
	private StringBuffer xml2 = null;
	
	/**
	 * Constructeur
	 * @param mainChannel Channel principale
	 */
	public ViewPermissions(MainChannel mainChannel) {
		super(mainChannel);
	}

	/**
	 * Retourne le niveau d'accrditation minimum pour accder  cette action
	 * @return ISecurityManager.VALIDATOR
	 */
	public int getLevel() {
		return ISecurityManager.VALIDATOR;
	}
	
	/**
	 * Mthode appele si la personne a le niveau requis
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon 
	 */
	public Boolean action() throws PortalException, FrameWorkException {
		if(log.isDebugEnabled()) {
		    log.debug("ViewPermissions::action()");
		}
		
		groups = new Hashtable();
		
		Collection groups = null;
		
		// Rcupration IDataControler
		IDataControler data = DataFactory.make();
		
		// Rcupration Valideurs et Publicateurs
		try {
			validators = data.getValidators(folderid);
			users = data.getUsersPublicators(folderid);
			groups = data.getGroupsPublicators(folderid);
		}
		catch(DataException e) {
			log.error("ViewPermissions::action() : DataException : " + e);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "default");
			return Boolean.FALSE;
		}
		
		// Rcupration des noms des valideurs
		Iterator i = validators.iterator();
		while(i.hasNext()) {
		    User tmp = (User)i.next();
		    tmp.setDisplayName(Users.getUserDisplayName(tmp.getLogin()));
		}
		
		// Rcupration des noms des publicateurs
		i = users.iterator();
		while(i.hasNext()) {
		    User tmp = (User)i.next();
		    tmp.setDisplayName(Users.getUserDisplayName(tmp.getLogin()));
		}
		
		// Rcupration des noms des groupes de publicateurs
		i = groups.iterator();
		while(i.hasNext()) {
			String tmp = (String)i.next();
			String name = null;
			try {
				name = Groups.getGroupName(tmp);
				this.groups.put(tmp, name);
			}
			catch(GroupsException e) {
				log.error("ViewPermissions::action() : " + e);
			}
		}
		return Boolean.TRUE;
	}
	
	/**
	 * Affichage des permissions pour ce dossier
	 * @return Boolean.TRUE
	 */
	public Boolean setXML() {
		StringBuffer xml = new StringBuffer();
		xml.append("<validators>\n");
		Iterator i = validators.iterator();
		while(i.hasNext()) {
		    User tmp = (User)i.next();
			xml.append(tmp.toXMLString());
		}
		xml.append("</validators>\n");
		xml.append("<publicators>\n");
		xml.append("<groups>\n");
		i = groups.keySet().iterator();
		while(i.hasNext()) {
			String key = (String)i.next();
			String value = (String)groups.get(key);
			xml.append("<group id=\"" + key + "\" name=\"" + XMLEscaper.escape(value) + "\" />\n");
		}
		xml.append("</groups>\n");
		xml.append("<users>\n");
		i = users.iterator();
		while(i.hasNext()) {
			User tmp = (User)i.next();
			xml.append(tmp.toXMLString());
		}
		xml.append("</users>\n");
		xml.append("</publicators>\n");
		this.xml = xml.toString();
		xslParameters.put("folderid", folderid);
		return Boolean.TRUE;
	}

	/**
	 * Suppression de publicateurs
	 * @param rd
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean pubinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		runtimeData = rd;
		if(log.isDebugEnabled()) {
		    log.debug("ViewPermissions::pubinit()");
		}
		
		// Vrification Permissions
		if(!superuser && role < getLevel()) {
			log.error("ViewPermissions::pubinit()() : Acc\u00E8s non autoris\u00E9");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration bouton
		String button = runtimeData.getParameter("butadd");
		
		// Slection bouton
		if(button != null) {
			mainChannel.redirect(runtimeData, "groupspub");
			return Boolean.FALSE;
		}
		
		// Rcupration paramtres
		String [] uids = runtimeData.getParameterValues("uid");
		String [] gids = runtimeData.getParameterValues("gid");
		
		// Vrification paramtres
		if((uids == null || uids.length == 0) && (gids == null || gids.length == 0)) {
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "permissions");
			return Boolean.FALSE;
		}
		
		// Rcupration IDataControler
		IDataControler data = DataFactory.make();
		
		Vector v = new Vector();
		if(gids != null && gids.length != 0) {
			for(int i=0;i<gids.length;i++) {
				String groupname = null;
				try {
					groupname = Groups.getGroupName(gids[i]);
				}
				catch(GroupsException e) {
					log.error("ViewPermissions::pubinit() : " + e); 
				}	
				if(groupname != null) {
					try {
						data.removePublicators(folderid, gids[i]);
						v.add(new MessageBean(groupname + " : Groupe supprim\u00E9", Message.INFO));
					}
					catch(DataException e) {
						log.error("ViewPermissions::pubinit() : " + e);
						v.add(new MessageBean(groupname + " : " + e.getMessage(), Message.ERROR));
					}
				}
			}
		}
		
		if(uids != null && uids.length != 0) {
			for(int i=0;i<uids.length;i++) {
				User user = new User();
				user.setLogin(uids[i]);
				user.setDisplayName(Users.getUserDisplayName(user.getLogin()));
				try {
					data.removePublicator(folderid, uids[i]);
					v.add(new MessageBean(user.getDisplayName() + " : Publicateur supprim\u00E9", Message.INFO));
				}
				catch(DataException e) {
					log.error("ViewPermissions::pubinit() : " + e);
					v.add(new MessageBean(user.getDisplayName() + " : " + e.getMessage(), Message.ERROR));
				}
			}
		}
		Hashtable parameters = new Hashtable();
		parameters.put("folderid", folderid);
		Message.message(mainChannel, runtimeData, v, "permissions", parameters);		
		return Boolean.FALSE;
	}
	
	/**
	 * Suppression de valideurs
	 * @param rd
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean valinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		runtimeData = rd;
		if(log.isDebugEnabled()) {
		    log.debug("ViewPermissions::valinit()");
		}
		
		// Vrification Permissions
		if(!superuser && role < getLevel()) {
			log.error("ViewPermissions::valinit()() : Acc\u00E8s non autoris\u00E9");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration bouton
		String button = runtimeData.getParameter("butadd");
		
		// Slection bouton
		if(button != null) {
			mainChannel.redirect(runtimeData, "annuaireval");
			return Boolean.FALSE;
		}
		
		// Rcupration paramtres
		String [] uids = runtimeData.getParameterValues("uid");
		
		// Vrification paramtres
		if(uids == null || uids.length == 0) {
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "permissions");
			return Boolean.FALSE;
		}
		
		// Rcupration IDataControler
		IDataControler data = DataFactory.make();
		
		Vector v = new Vector();
		for(int i=0;i<uids.length;i++) {
			User user = new User();
			user.setLogin(uids[i]);
			user.setDisplayName(Users.getUserDisplayName(user.getLogin()));
			try {
				data.removeValidator(folderid, uids[i]);
				v.add(new MessageBean(user.getDisplayName() + " : Valideur supprim\u00E9", Message.INFO));
			}
			catch(DataException e) {
				log.error("ViewPermissions::valinit() : " + e);
				v.add(new MessageBean(user.getDisplayName() + " : " + e.getMessage(), Message.ERROR));
			}
		}
		
		Hashtable parameters = new Hashtable();
		parameters.put("folderid", folderid);
		Message.message(mainChannel, runtimeData, v, "permissions", parameters);		
		return Boolean.FALSE;
	}

	/**
	 * Ajout de groupes aux publicateurs
	 * @param rd
	 * @return Boolean.TRUE si l'action s'est bien passe, Boolean.FALSE sinon
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean groupinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		runtimeData = rd;
		if(log.isDebugEnabled()) {
		    log.debug("ViewPermissions::groupinit()");
		}
		
		// Vrification Permissions
		if(!superuser && role < getLevel()) {
			log.error("ViewPermissions::groupinit()() : Acc\u00E8s non autoris\u00E9");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration IDataReadManager
		IDataControler data = DataFactory.make();
		
		// Rcupration population
		Population population = null;
		try {
			population = data.getPopulation(intranet);
		}
		catch(DataException e) {
			log.error("ViewPermissions::valinit() : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "permissions", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration des noms de groupes
		this.population = new Hashtable();
		this.population.put("_EVERYBODY", "Tous les membres");
		Iterator i = population.getGroups().iterator();
		while(i.hasNext()) {
			try {
				String tmp = (String)i.next();
				String name = Groups.getGroupName(tmp);
				this.population.put(tmp, name);
			}
			catch(GroupsException e) {
				log.error("ViewPermissions::valinit() : " + e);
			}
		}
		return Boolean.TRUE;
	}
	
	/**
	 * Affiche la liste des groupes de valideurs disponibles
	 * @return Boolean.TRUE
	 */
	public Boolean groupxml() {
		xml2 = new StringBuffer();
		xml2.append("<groups>\n");
		Enumeration e = population.keys();
		while(e.hasMoreElements()) {
			String tmp = (String)e.nextElement();
			xml2.append("<group id=\"" + tmp + "\" name=\"" + XMLEscaper.escape((String)population.get(tmp)) + "\" />\n");
		}
		xml2.append("</groups>\n");
		this.xml = xml2.toString();
		xslParameters.put("folderid", folderid);
		return Boolean.TRUE;
	}
	
	/**
	 * Ajout d'un groupe de publicateurs
	 * @param rd
	 * @return Boolean.FALSE (pas d'affichage)
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean addgroupinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		runtimeData = rd;
		if(log.isDebugEnabled()) {
		    log.debug("ViewPermissions::addgroupinit()");
		}
		
		// Vrification Permissions
		if(!superuser && role < getLevel()) {
			log.error("ViewPermissions::addgroupinit()() : Acc\u00E8s non autoris\u00E9");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration bouton
		String button = runtimeData.getParameter("butvalid");
		
		// Slection bouton
		if(button == null) {
			mainChannel.redirect(runtimeData, "annuairepub");
			return Boolean.FALSE;
		}
		
		// Rcupration paramtres
		String [] gids = runtimeData.getParameterValues("gid");
		
		// Vrification paramtres
		if(gids == null || gids.length == 0) {
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "permissions");
			return Boolean.FALSE;
		}
		
		// Rcupration IDataControler
		IDataControler data = DataFactory.make();
		
		for(int i=0;i<gids.length;i++) {
			String gid = gids[i];
			if(!groups.contains(gid)) {
				try {
					data.addPublicators(folderid, gid);
				}
				catch(DataException e) {
					log.error("ViewPermissions::addgroupinit() : " + e);
				}
			}
		}
		runtimeData.setParameter("folderid", folderid);
		mainChannel.redirect(runtimeData, "permissions");
		return Boolean.FALSE;
	}
	
	/**
	 * Ajout d'un publicateur (retour du servant Annuaire)
	 * @param rd
	 * @return Boolean.FALSE (pas d'affichage)
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean addpubinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		runtimeData = rd;
		if(log.isDebugEnabled()) {
		    log.debug("ViewPermissions::addpubinit()");
		}
		
		// Vrification Permissions
		if(!superuser && role < getLevel()) {
			log.error("ViewPermissions::addpubinit()() : Acc\u00E8s non autoris\u00E9");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration rsultats servant
		Object [] res = mainChannel.getServantResults();
		if(res == null || res.length != 1) {
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "permissions");
			return Boolean.FALSE;
		}
		Personne selected = (Personne)res[0];
		
		// Rcupration IDataControler
		IDataControler data = DataFactory.make();
		
		// Rcupration ISecurityManager
		ISecurityManager security = SecurityFactory.make();
		if(security == null) {
			log.error("ViewPermissions::addpubinit() : security = null");
			Message.message(mainChannel, runtimeData, new MessageBean("Impossible d'acc\u00E9der au service de s\u00E9curit\u00E9"));
			return Boolean.FALSE;
		}
		
		try {
		    User user = new User();
		    user.setLogin(selected.getIdentifiant());
			user.setDisplayName(Users.getUserDisplayName(user.getLogin()));
			if(!security.isIntranetAccessible(intranet, user.getLogin())) {
				log.error("ViewPermissions::addpubinit() : " + user.getDisplayName() + " ne fait pas partie de cet intranet");
				Hashtable parameters = new Hashtable();
				parameters.put("folderid", folderid);
				Message.message(mainChannel, runtimeData, new MessageBean(user.getDisplayName() + " n'est pas membre de cet intranet"), "permissions", parameters);
				return Boolean.FALSE;
			}
			if(users.contains(user)) {
				runtimeData.setParameter("folderid", folderid);
				mainChannel.redirect(runtimeData, "permissions");
				return Boolean.FALSE;
			}
			data.addPublicator(folderid, user.getLogin());
		}
		catch(SecurityException e) {
			log.error("ViewPermissions::addpubinit() : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "permissions", parameters);
			return Boolean.FALSE;
		}
		catch(DataException e) {
			log.error("ViewPermissions::addpubinit() : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "permissions", parameters);
			return Boolean.FALSE;
		}
		
		runtimeData.setParameter("folderid", folderid);
		mainChannel.redirect(runtimeData, "permissions");
		return Boolean.FALSE;
	}
	
	/**
	 * Ajout d'un valideur (retour du servant Annuaire)
	 * @param rd
	 * @return Boolean.FALSE (pas d'affichage)
	 * @throws PortalException
	 * @throws FrameWorkException
	 */
	public Boolean addvalinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
		runtimeData = rd;
		if(log.isDebugEnabled()) {
		    log.debug("ViewPermissions::addvalinit()");
		}
		
		// Vrification Permissions
		if(!superuser && role < getLevel()) {
			log.error("ViewPermissions::addvalinit()() : Acc\u00E8s non autoris\u00E9");
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		// Rcupration rsultats servant
		Object [] res = mainChannel.getServantResults();
		if(res == null || res.length != 1) {
			runtimeData.setParameter("folderid", folderid);
			mainChannel.redirect(runtimeData, "permissions");
			return Boolean.FALSE;
		}
		Personne selected = (Personne)res[0];
		
		// Rcupration IDataControler
		IDataControler data = DataFactory.make();
		
		// Rcupration ISecurityManager
		ISecurityManager security = SecurityFactory.make();
		if(security == null) {
			log.error("ViewPermissions::addvalinit() : security = null");
			Message.message(mainChannel, runtimeData, new MessageBean("Impossible d'acc\u00E9der au service de s\u00E9curit\u00E9"));
			return Boolean.FALSE;
		}
		
		try {
			User user = new User();
			user.setLogin(selected.getIdentifiant());
			user.setDisplayName(Users.getUserDisplayName(user.getLogin()));
			if(!security.isIntranetAccessible(intranet, user.getLogin())) {
				log.error("ViewPermissions::addvalinit() : " + user.getDisplayName() + " ne fait pas partie de cet intranet");
				Hashtable parameters = new Hashtable();
				parameters.put("folderid", folderid);
				Message.message(mainChannel, runtimeData, new MessageBean(user.getDisplayName() + " n'est pas membre de cet intranet"), "permissions", parameters);
				return Boolean.FALSE;
			}
			if(validators.contains(user)) {
				runtimeData.setParameter("folderid", folderid);
				mainChannel.redirect(runtimeData, "permissions");
				return Boolean.FALSE;
			}
			data.addValidator(folderid, user.getLogin());
		}
		catch(SecurityException e) {
			log.error("ViewPermissions::addvalinit() : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "permissions", parameters);
			return Boolean.FALSE;
		}
		catch(DataException e) {
			log.error("ViewPermissions::addvalinit() : " + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folderid", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "permissions", parameters);
			return Boolean.FALSE;
		}
		
		runtimeData.setParameter("folderid", folderid);
		mainChannel.redirect(runtimeData, "permissions");
		return Boolean.FALSE;
	}
}
