package org.esupportail.portal.channels.CIntranet.beans;

import java.util.Collection;
import java.util.Iterator;

import org.jasig.portal.utils.XMLEscaper;

/**
 * FolderTree<br>
 * <br>
 * Cette classe permet de manipuler une arborescence de rpertoires<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */
public class FolderTree extends SubFolder {
    
    private Collection subfolders = null;
    
    /**
     * Constructeur
     */
    public FolderTree() {
    }
    
    /**
     * Les sous dossiers
     * @param subfolders
     */
    public void setSubfolder(Collection subfolders) {
        this.subfolders = subfolders;
    }
    
    /**
     * Retourne la reprsentation XML de cette arborescence
     * @return Le flux XML
     */
    public String toXMLString() {
        StringBuffer xml = new StringBuffer();
        xml.append("<folder id=\"" + getId() + "\" ");
        xml.append("name=\"" + XMLEscaper.escape(getName()) + "\" ");
        xml.append("intranet=\"" + getIntranet() + "\">\n");
        Iterator i = subfolders.iterator();
        while(i.hasNext()) {
            FolderTree tmp = (FolderTree)i.next();
            xml.append(tmp.toXMLString());
        }
        xml.append("</folder>\n");
        return xml.toString();
    }
}
