package org.esupportail.portal.channels.CIntranet.beans;

import org.jasig.portal.utils.XMLEscaper;

/**
 * Intranet<br>
 * <br>
 * Cette classe permet de manipuler les informations relatives  un intranet<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */

public class Intranet {

	private String id = null;
	private String name = null;
	private String root = null;
	private String ressource = null;

	/**
	 * Constructeur
	 */
	public Intranet() {
	}

	/**
	 * L'identifiant de cet intranet
	 * @return
	 */
	public String getId() {
		return id;
	}

	/**
	 * L'identifiant de cet intranet
	 * @param id
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * Le nom de cet intranet
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * Le nom de cet intranet
	 * @param name
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Le dossier racine de cet intranet
	 * @return
	 */
	public String getRoot() {
		return root;
	}

	/**
	 * Le dossier racine de cet intranet
	 * @param root
	 */
	public void setRoot(String root) {
		this.root = root;
	}

	/**
	 * La ressource de stockage associe  cet intranet
	 * @return
	 */
	public String getRessource() {
		return ressource;
	}

	/**
	 * La ressource de stockage associe  cet intranet
	 * @param ressource
	 */
	public void setRessource(String ressource) {
		this.ressource = ressource;
	}

	/**
	 * La reprsentation XML de cet intranet
	 * @return
	 */
	public String toXMLString() {
		StringBuffer xml = new StringBuffer();
		xml.append("<intranet ");
		xml.append("id=\"" + getId() + "\" ");
		xml.append("name=\"" + XMLEscaper.escape(getName()) + "\" ");
		xml.append("ressource=\"" + getRessource() + "\" ");
		xml.append("root=\"" + getRoot() + "\" />\n");
		return xml.toString();
	}
}
