package org.esupportail.portal.channels.CIntranet.cache;

import java.util.Hashtable;

/**
 * CircularCache<br>
 * <br>
 * Implmentation d'un cache sous la forme d'un buffer circulaire de taille fixe
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */

public class CircularCache implements Cache {
	
	private int size = 0;
	private int index = 0;
	private Object [] keys = null;
	private Hashtable values = null;
	
	/**
	 * Constructeur
	 * @param size La taille du buffer circulaire
	 */
	public CircularCache(int size) {
		this.size = size;
		keys = new Object[size];
		values = new Hashtable();
	}
	
	/**
	 * Mise en cache d'un objet
	 * @param key Cl du cache
	 * @param value Valeur mise en cache
	 */
	public synchronized void put(Object key, Object value) {
		if(keys[index] != null) {
			values.remove(keys[index]);
		}
		keys[index] = key;
		values.put(key, value);
		index = (++index) % size;
	}

	/**
	 * Rcupration d'un objet du cache
	 * @param key Cl du cache
	 * @return Valeur mise en cache si trouve, null sinon
	 */
	public synchronized Object get(Object key) {
		return values.get(key);
	}

	/**
	 * Suppression d'un objet du cache
	 * @param key Cl du cache
	 */
	public void remove(Object key) {
		values.remove(key);
	}
}
