package org.esupportail.portal.channels.CIntranet.data;

import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.utils.database.Query;

/**
 * DataOrder<br>
 * <br>
 * Classe d'accs aux donnes manipulant l'ordre des documents<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */
public class DataOrder implements IDataOrder {
    
    protected static final Log log = LogFactory.getLog(DataOrder.class);
    
    /**
     * Monte la pile de priorit de 1 rang
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @throws DataException
     */
    public void push(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataOrder::push()");
        }
        
        String sql = "UPDATE INT_DOCUMENT SET ORDER_DOC = ORDER_DOC + 1 WHERE ID_DOS = " + id;
        try {
            query.setSql(sql);
            query.update();
        }
        catch(SQLException e) {
            log.error("DataOrder::push() : " + e);
			log.error("DataOrder::push() : SQL : " + sql);
			throw new DataException("Erreur lors du d\u00E9calage des rangs");
        }
    }
    
    /**
     * Descend la pile de priorit  partir d'un certain rang
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @param order Le rang  partir duquel on travaille
     * @throws DataException
     */
    public void pull(Query query, String id, String order) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataOrder::pull()");
        }
        
        String sql = "UPDATE INT_DOCUMENT SET ORDER_DOC = ORDER_DOC - 1 WHERE ID_DOS = " + id + " AND ORDER_DOC > " + order;
        try {
            query.setSql(sql);
            query.update();
        }
        catch(SQLException e) {
            log.error("DataOrder::pull() : " + e);
			log.error("DataOrder::pull() : SQL : " + sql);
			throw new DataException("Erreur lors du d\u00E9calage des rangs");
        }
    }
    
    /**
     * Echange le rang de deux documents
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @param doc L'identifiant du document
     * @param oldorder L'ancien rang du document
     * @param neworder Le nouveau rang du document
     * @throws DataException
     */
    public void swap(Query query, String id, String doc, String oldorder, String neworder) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataOrder::swap()");
        }
        
        String sql = "UPDATE INT_DOCUMENT SET ORDER_DOC = " + oldorder + " WHERE ORDER_DOC = " + neworder + " AND ID_DOS = " + id;
        try {
            query.setSql(sql);
            query.update();
            sql = "UPDATE INT_DOCUMENT SET ORDER_DOC = " + neworder + " WHERE ID_DOC = '" + doc + "' AND ID_DOS = " + id;
            query.setSql(sql);
            query.update();
        }
        catch(SQLException e) {
            log.error("DataOrder::swap() : " + e);
			log.error("DataOrder::swap() : SQL : " + sql);
			throw new DataException("Erreur lors de l'inversion des rangs");
        }
        
    }
}
