package org.esupportail.portal.channels.CIntranet.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Population;
import org.esupportail.portal.channels.CIntranet.beans.User;
import org.esupportail.portal.utils.database.Query;

/**
 * DataPopulation<br>
 * <br>
 * Classe d'accs aux donnes manipulant les populations<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.1
 * 
 */
public class DataPopulation implements IDataPopulation {
    
    protected static final Log log = LogFactory.getLog(DataPopulation.class);

    /**
	 * Rcupration d'une population
	 * @param query La connexion  utiliser
	 * @param id L'identifiant d'intranet
	 * @return La population de l'intranet
	 * @throws DataException
	 */
    public synchronized Population getPopulation(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataPopulation::getPopulation()");
        }
		Population res = new Population();
		Collection groups = new Vector();
		Collection users = new Vector();
		
		StringBuffer sql1 = new StringBuffer();
		sql1.append("SELECT ID_POP FROM INT_POPULATION WHERE ");
		sql1.append("ID_INT = '" + id + "' AND TYPE_POP = 'U'");
		
		StringBuffer sql2 = new StringBuffer();
		sql2.append("SELECT ID_POP FROM INT_POPULATION WHERE ");
		sql2.append("ID_INT = '" + id + "' AND TYPE_POP = 'G'");
		
		
		try {
			query.setSql(sql1.toString());
			query.select();
			ResultSet result = query.getRs();
			while(result.next()) {
			    User tmp = new User();
			    tmp.setLogin(result.getString("ID_POP"));
				users.add(tmp);
			}
			res.setUsers(users);
			query.setSql(sql2.toString());
			query.select();
			result = query.getRs();
			while(result.next()) {
				groups.add(result.getString("ID_POP"));
			}
			res.setGroups(groups);
		}
		catch(SQLException e) {
			log.error("DataPopulation::getPopulation() : " + e);
			throw new DataException("Erreur lors de la lecture de la population");
		}
		return res;
    }

    /**
	 * Ajout d'une population
	 * @param query La connexion  utiliser
	 * @param population La population  ajouter
	 */
    public synchronized void addPopulation(Query query, Population population) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("DataPopulation::getPopulation()");
        }
		
		StringBuffer sql = new StringBuffer();
		sql.append("INSERT INTO INT_POPULATION(ID_INT, TYPE_POP, ID_POP) VALUES(");
		sql.append("'" + population.getIntranet() + "', ");
		sql.append("'%T', ");
		sql.append("'%I')");
		
		try {
			Iterator i = population.getUsers().iterator();
			String req = sql.toString().replaceFirst("%T", "U");
			while(i.hasNext()) {
				User tmp = (User)i.next();
				String reqtmp = req.replaceFirst("%I", tmp.getLogin());
				query.setSql(reqtmp);
				query.insert();
			}
			
			i = population.getGroups().iterator();
			req = sql.toString().replaceFirst("%T", "G");
			while(i.hasNext()) {
				String tmp = (String)i.next();
				String reqtmp = req.replaceFirst("%I", tmp);
				query.setSql(reqtmp);
				query.insert();
			}
		}
		catch(SQLException e) {
			log.error("DataPopulation::addPopulation() : " + e);
			log.error("DataPopulation::addPopulation() : SQL : " + sql);
			throw new DataException("Erreur lors de l'ajout de la population");
		}
    }

    /**
	 * Suppression d'un groupe d'une population
	 * @param query La connexion  utiliser
	 * @param group L'identifiant du groupe  supprimer
	 * @param intranet L'identifiant de l'intranet dont on souhaite supprimer la population
	 * @throws DataException
	 */
	public synchronized void removeGroupFromPopulation(Query query, String group, String intranet) throws DataException {
	    if(log.isDebugEnabled()) {
	        log.debug("DataPopulation::removeGroupFromPopulation()");
	    }
	    
	    String sql = "DELETE FROM INT_POPULATION WHERE TYPE_POP = 'G' AND ID_POP = '" + group + "'";
	    try {
	        query.setSql(sql);
	        query.delete();
	    }
	    catch(SQLException e) {
	        log.error("DataPopulation::removeGroupFromPopulation() : " + e);
			log.error("DataPopulation::removeGroupFromPopulation() : SQL : " + sql);
			throw new DataException("Erreur lors de la suppression du groupe");
	    }
	}
	
	/**
	 * Suppression d'un groupe d'une population
	 * @param query La connexion  utiliser
	 * @param login Le login de l'utilisateur  supprimer
	 * @param intranet L'identifiant de l'intranet dont on souhaite supprimer la population
	 * @throws DataException
	 */
	public synchronized void removeUserFromPopulation(Query query, String login, String intranet) throws DataException {
	    if(log.isDebugEnabled()) {
	        log.debug("DataPopulation::removeUserFromPopulation()");
	    }
	    
	    String sql = "DELETE FROM INT_POPULATION WHERE TYPE_POP = 'U' AND ID_POP = '" + login + "'";
	    try {
	        query.setSql(sql);
	        query.delete();
	    }
	    catch(SQLException e) {
	        log.error("DataPopulation::removeUserFromPopulation() : " + e);
			log.error("DataPopulation::removeUserFromPopulation() : SQL : " + sql);
			throw new DataException("Erreur lors de la suppression de l'utilisateur");
	    }
	}
}
