package org.esupportail.portal.channels.CIntranet.data;

import org.esupportail.portal.utils.database.Query;

/**
 * IDataOrder<br>
 * <br>
 * Commentaire<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */
public interface IDataOrder {
    /**
     * Monte la pile de priorit de 1 rang
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @throws DataException
     */
    public void push(Query query, String id) throws DataException;
    
    /**
     * Descend la pile de priorit  partir d'un certain rang
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @param order Le rang  partir duquel on travaille
     * @throws DataException
     */
    public void pull(Query query, String id, String order) throws DataException;
    
    /**
     * Echange le rang de deux documents
     * @param query La connexion  utiliser
     * @param id L'identifiant du dossier
     * @param doc L'identifiant du document
     * @param oldorder L'ancien rang du document
     * @param neworder Le nouveau rang du document
     * @throws DataException
     */
    public void swap(Query query, String id, String doc, String oldorder, String neworder) throws DataException;
}
