package org.esupportail.portal.channels.CIntranet.data;

import org.esupportail.portal.channels.CIntranet.beans.Population;
import org.esupportail.portal.utils.database.Query;

/**
 * IDataPopulation<br>
 * <br>
 * Cette interface dcrit les mthodes d'accs aux populations<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.1
 * 
 */
public interface IDataPopulation {

    /**
	 * Rcupration d'une population
	 * @param query La connexion  utiliser
	 * @param id L'identifiant d'intranet
	 * @return La population de l'intranet
	 * @throws DataException
	 */
	public Population getPopulation(Query query, String id) throws DataException;
	
	/**
	 * Ajout d'une population
	 * @param query La connexion  utiliser
	 * @param population La population  ajouter
	 */
	public void addPopulation(Query query, Population population) throws DataException;
	
	/**
	 * Suppression d'un groupe d'une population
	 * @param query La connexion  utiliser
	 * @param group L'identifiant du groupe  supprimer
	 * @param intranet L'identifiant de l'intranet dont on souhaite supprimer la population
	 * @throws DataException
	 */
	public void removeGroupFromPopulation(Query query, String group, String intranet) throws DataException;
	
	/**
	 * Suppression d'un groupe d'une population
	 * @param query La connexion  utiliser
	 * @param login Le login de l'utilisateur  supprimer
	 * @param intranet L'identifiant de l'intranet dont on souhaite supprimer la population
	 * @throws DataException
	 */
	public void removeUserFromPopulation(Query query, String login, String intranet) throws DataException;
}
