package org.esupportail.portal.channels.CIntranet.security;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.config.Config;

/**
 * SecurityFactory<br>
 * <br>
 * Fabrique de ISecurityManager<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */

public class SecurityFactory {
	
    protected static final Log log = LogFactory.getLog(SecurityFactory.class);
	private static ISecurityManager singleton = null;
	
	/**
	 * Construit un ISecurityManager et implmente un mcanisme<br>
	 * de singleton
	 * @return L'implmentation du ISecurityManager correspondante
	 */
	public static ISecurityManager make() {
		if(singleton != null) {
			return singleton;
		}
		
		Class securityManagerClass = null;
		Object securityManagerObject = null;
		ISecurityManager res = null;
		String classname = Config.getInstance().getSecurityManager();
		
		if(classname == null) {
			log.fatal("SecurityFactory::make() : classname null");
			return res;
		}
		
		try {
			if(log.isDebugEnabled()) {
			    log.debug("SecurityFactory::make() : Tentative d'instanciation du SecurityManager " + classname);
			}
			securityManagerClass = Class.forName(classname);
			securityManagerObject = securityManagerClass.newInstance();
			res = (ISecurityManager)securityManagerObject;
		}
		catch(Exception e) {
			res = null;
			log.fatal("SecurityFactory::make() : Echec de l'instanciation du SecurityManager " + classname);
			log.fatal("SecurityFactory::make() : Exception " + e);
		}
		singleton = res;
		return singleton;
	}
}
