package org.esupportail.portal.channels.CIntranet.storage;

import java.io.InputStream;
import java.util.Hashtable;

import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.beans.Intranet;

/**
 * IStorageControler<br>
 * <br>
 * Interface dcrivant les mthodes que doit obligatoirement implmenter<br>
 * un contrleur de ressource de stockage physique<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */

public interface IStorageControler {
	
	/**
	 * Sauvegarde d'un document
	 * @param intranet L'intranet auquel appartient le document
	 * @param doc Le document
	 * @param in Le flux de lecture vers le contenu du document
	 * @throws StorageException
	 */
	public void saveDocument(String intranet, Document doc, InputStream in) throws StorageException;
	
	/**
	 * Lecture d'un document
	 * @param intranet L'intranet auquel appartient le document
	 * @param doc Le document
	 * @return Le flux de lecture vers le document stock
	 * @throws StorageException
	 */
	public InputStream loadDocument(String intranet, Document doc) throws StorageException;
	
	/**
	 * Mise  jour d'un document
	 * @param intranet L'intranet auquel appartient le document
	 * @param doc Le document
	 * @param in Le flux de lecture vers le nouveau contenu, null si pas de mise  jour du contenu
	 * @throws StorageException
	 */
	public void updateDocument(String intranet, Document doc, InputStream in) throws StorageException;
	
	/**
	 * Suppression d'un document
	 * @param intranet L'intranet auquel appartient le document
	 * @param doc Le document
	 * @throws StorageException
	 */
	public void destroyDocument(String intranet, Document doc) throws StorageException;
	
	/**
	 * Validation d'un document
	 * @param intranet L'intranet auquel appartient le document
	 * @param doc Le document  valider
	 * @throws StorageException
	 */
	public void validDocument(String intranet, Document doc) throws StorageException;
	
	/**
	 * Invalidation d'un document
	 * @param intranet L'intranet auquel appartient le document
	 * @param doc Le document  invalider
	 * @throws StorageException
	 */
	public void invalidDocument(String intranet, Document doc) throws StorageException;
	
	/**
	 * Cration d'un intranet
	 * @param intranet L'intranet  crer
	 * @throws StorageException
	 */
	public void createIntranet(Intranet intranet) throws StorageException;
	
	/**
	 * Suppression d'un intranet et de tous ses documents
	 * @param intranet L'intranet  supprimer
	 * @throws StorageException
	 */
	public void destroyIntranet(String intranet) throws StorageException;
	
	/**
	 * Liste des paramtres spcifiques  l'implmentation du IStorageControler
	 * @param parameters
	 */
	public void setParameters(Hashtable parameters);
}
