package org.esupportail.portal.channels.CIntranet.storage;

import java.util.Hashtable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Ressource;
import org.esupportail.portal.channels.CIntranet.config.Config;

/**
 * StorageFactory<br>
 * <br>
 * Fabrique de IStorageControler<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */

public class StorageFactory {
	
    protected static final Log log = LogFactory.getLog(StorageFactory.class);
    private static Hashtable singletons = null;
		
	/**
	 * Construit un IStorageControler  partir de la ressource<br>
	 * dclare dans le fichier de configuration
	 * @param ressource La ressource  laquelle on souhaite accder
	 * @return L'implmentation du IStorageControler correspondante
	 */
	public static IStorageControler make(String ressource) {
		IStorageControler res = null;
		
		if(singletons == null) {
			singletons = new Hashtable();
		}
		else {
			 res = (IStorageControler)singletons.get(ressource);
			if(res != null) {
				return res;
			}
		}
		
		Class storageControlerClass = null;
		Object storageControlerObject = null;
		Ressource current = (Ressource)Config.getInstance().getRessources().get(ressource);
		if(current == null) {
			log.fatal("StorageFactory::make() : ressource null");
			return res;
		}
		
		String classname = current.getClassname();
		
		try {
		    if(log.isDebugEnabled()) {
			    log.debug("StorageFactory::make() : Tentative d'instanciation du StorageControler " + ressource + " " + classname);
		    }
			storageControlerClass = Class.forName(classname);
			storageControlerObject = storageControlerClass.newInstance();
			res = (IStorageControler)storageControlerObject;
			res.setParameters(current.getParameters());
		}
		catch(Exception e) {
			res = null;
			log.fatal("StorageFactory::make() : Echec de l'instanciation du StorageControler " + ressource + " " + classname);
			log.fatal("StorageFactory::make() : Exception " + e);
		}
		singletons.put(ressource, res);
		return res;
	}
}
