package org.esupportail.portal.channels.CIntranet.utils;

import java.text.SimpleDateFormat;

/**
 * Date<br>
 * <br>
 * Classe permettant de manipuler des dates<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version 2.0
 * 
 */

public class Date {
	
	private static String [] mois = {"janvier", "f\u00E9vrier", "mars", "avril", "mai", "juin", "juillet", "ao\u00FBt", "septembre", "octobre", "novembre", "d\u00E9cembre"};
	
	/**
	 * Mise en forme d'une date YYYYMMDD sous la forme franaise
	 * @param date La date  formater
	 * @return la date formate
	 */
	public static String formatDate(String date) {
		String annee = date.substring(0,4);
		String moi = mois[new Integer(date.substring(4,6)).intValue() - 1];
		String jour = date.substring(6);
		return jour + " " + moi + " " + annee;
	}
	
	/**
	 * Retourne la date courante au format YYYYMMDD
	 * @return
	 */
	public static String getCurrentDate() {
		return new SimpleDateFormat("yyyyMMdd").format(new java.util.Date());
	}
}
