<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:import href="./ViewFolder_templates.xsl" />

<xsl:output method="html" indent="no" />

<xsl:param name="baseActionURL" />
<xsl:param name="baseDownloadURL" />
<xsl:param name="prefForm" />
<xsl:param name="mediaPath" />

<xsl:template match="folder">

<script language="javascript" src="{$mediaPath}functions.js" >
</script>
	
	<table width="100%" border="0" cellspacing="0" cellpadding="5">
		<tr>
			<xsl:call-template name="outil.actualiser"/>
			<xsl:call-template name="outil.nouveau.document"/>
			<xsl:if test="./@validation='false'">
				<xsl:call-template name="outil.nouveau.dossier" />
			</xsl:if>
			<xsl:call-template name="outil.arbre" />
			<xsl:call-template name="outil.intranets"/>
			
			<td width="100%">&#160;</td>
		</tr>
	</table>
	<hr/>
	<br/>
	
	<!-- Affichage chemin courant -->
	<table border="0" width="100%">
		<tr>
			<xsl:apply-templates select="path/subfolder" />
			<td width="100%">&#160;</td>
		</tr>
	</table>
	
	<!-- Affichage des sous-dossiers -->		
	<xsl:apply-templates select="subfolders" />
	
	<!-- Affichage des documents -->
	<xsl:apply-templates select="documents" />

</xsl:template>

<!-- Affichage des documents -->
<xsl:template match="documents">
	
	<xsl:if test="count(document)!=0">
		<br/>
		
		<xsl:choose>
			<!-- Dossier non soumis à validation -->
			<xsl:when test="/xml/folder/@validation='false'">
			<!-- Formulaire multiple suppression uniquement -->
				<form name="{$prefForm}" method="post" action="{$baseActionURL}">
					<input type="hidden" name="action" value="multiple" />
					<input type="hidden" name="target" value="" />
					<input type="hidden" name="folderid" value="{/xml/folder/@id}" />

					<!--<input type="submit" name="butsuppr" class="uportal-button" value="Supprimer" />-->
					<img src="{$mediaPath}deletedoc.gif" alt="Supprimer" title="Supprimer" border="0" onclick="subForm('{$prefForm}', 'target', 'delete');" />
					<br/>
					<br/>
					<table border="0" width="100%" cellpadding="1" cellspacing="0">
						<!-- Affichage des documents -->
						<xsl:apply-templates select="document">
							<xsl:sort select="@order" data-type="number" order="ascending" />
						</xsl:apply-templates>
					</table>			
					<br/>
					<img  src="{$mediaPath}deletedoc.gif" alt="Supprimer" title="Supprimer" border="0" onclick="subForm('{$prefForm}', 'target', 'delete');" />
					<!--<input type="submit" name="butsuppr" class="uportal-button" value="Supprimer" />-->
				</form>
			</xsl:when>
				
			<!-- Autres cas -->
			<xsl:otherwise>
			<!-- Pas de formulaire -->
				<table border="0" width="100%" cellpadding="1" cellspacing="0">
					<!-- Affichage des documents -->
					<xsl:apply-templates select="document">
							<xsl:sort select="@order" data-type="number" order="ascending" />
						</xsl:apply-templates>
				</table>	
			</xsl:otherwise>
		</xsl:choose>
		
	</xsl:if>
	
</xsl:template>

<!-- Affichage des options de document -->
<xsl:template match="document">
	
	<xsl:choose>
		
	<!-- Dossier soumis à validation document valide -->
		<xsl:when test="/xml/folder/@validation='true' and ./@valid='true'">
			<xsl:call-template name="validation.valid" />
		</xsl:when>
		
	<!-- Dossier soumis à validation document invalide -->
		<xsl:when test="/xml/folder/@validation='true' and ./@valid='false'">
			<xsl:call-template name="validation.invalid" />
		</xsl:when>
		
	<!-- Dossier non soumis à validation -->
		<xsl:otherwise >
			<xsl:call-template name="novalidation" />
		</xsl:otherwise>
		
	</xsl:choose>

</xsl:template>

<!-- Affichage des icones -->

<!-- Dossier soumis à validation document valide -->
<xsl:template name="validation.valid">
	<tr onmouseover="setPointer(this, 'over', 'uportal-background-med', 'BODY');" onmouseout="setPointer(this, 'out', 'uportal-background-med', 'BODY');">	
		<xsl:choose>
			<xsl:when test="./@locked='true'">
				<xsl:call-template name="icon.nocheckbox" />
				<xsl:call-template name="icon.zoom" />
				<xsl:call-template name="icon.locked" />
				<xsl:call-template name="icon.nodelete" />
				<xsl:call-template name="icon.noup" />
				<xsl:call-template name="icon.nodown" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="icon.nocheckbox" />
				<xsl:call-template name="icon.zoom" />
				<xsl:call-template name="icon.modify" />
				<xsl:call-template name="icon.nodelete" />
				<xsl:call-template name="icon.noup" />
				<xsl:call-template name="icon.nodown" />
			</xsl:otherwise>
		</xsl:choose>
		<td width="5%">&#160;</td>
		
		<xsl:choose>
			<xsl:when test="./@type='file'">
				<xsl:call-template name="document.fichier" />
			</xsl:when>
			<xsl:when test="./@type='link'">
				<xsl:call-template name="document.lien" />
			</xsl:when>
		</xsl:choose>

		<td width="100%">&#160;</td>
	</tr>
</xsl:template>

<!-- Dossier soumis à validation document invalide -->
<xsl:template name="validation.invalid">
	<tr class="uportal-background-highlight" onmouseover="setPointer(this, 'over', 'uportal-background-med', 'uportal-background-highlight');" onmouseout="setPointer(this, 'out', 'uportal-background-med', 'uportal-background-highlight');">	
		<xsl:call-template name="icon.nocheckbox" />
		<xsl:call-template name="icon.zoom" />
		<xsl:call-template name="icon.new" />
		<xsl:call-template name="icon.nodelete" />
		<xsl:call-template name="icon.noup" />
		<xsl:call-template name="icon.nodown" />
		<td width="5%">&#160;</td>
		
		<xsl:choose>
			<xsl:when test="./@type='file'">
				<xsl:call-template name="document.fichier" />
			</xsl:when>
			<xsl:when test="./@type='link'">
				<xsl:call-template name="document.lien" />
			</xsl:when>
		</xsl:choose>

		<td width="100%">&#160;</td>
	</tr>
</xsl:template>

<!-- Dossier non soumis à validation -->
<xsl:template name="novalidation">
	<tr onmouseover="setPointer(this, 'over', 'uportal-background-med', 'BODY');" onmouseout="setPointer(this, 'out', 'uportal-background-med', 'BODY');">	
		<xsl:call-template name="icon.checkbox" />
		<xsl:call-template name="icon.zoom" />
		<xsl:call-template name="icon.modify" />
		<xsl:call-template name="icon.delete" />
		<xsl:call-template name="icon.noup" />
		<xsl:call-template name="icon.nodown" />
		
		<td width="5%">&#160;</td>
		
		<xsl:choose>
			<xsl:when test="./@type='file'">
				<xsl:call-template name="document.fichier" />
			</xsl:when>
			<xsl:when test="./@type='link'">
				<xsl:call-template name="document.lien" />
			</xsl:when>
		</xsl:choose>

		<td width="100%">&#160;</td>
	</tr>
</xsl:template>
			
</xsl:stylesheet>