package org.esupportail.portal.channels.CIntranet.actions.admin;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.security.Security;
import org.esupportail.portal.channels.CIntranet.security.SecurityException;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.jasig.portal.security.IPerson;

/**
 * AbstractAction<br>
 * <br>
 * Dfinit un comportement par dfaut pour toutes les actions du canal d'administration<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class AbstractAction extends SubChannel {

    protected static Log log = LogFactory.getLog(AbstractAction.class);
    
    protected String userid = null;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public AbstractAction(MainChannel mainChannel) {
        super(mainChannel);
    }
    
    /**
     * Implmente un comportement par dfaut pour toutes les actions du canal d'administration
     * Si l'utilisateur n'est pas un administrateur, le canal affiche un message d'erreur
     * @param rd Les runtimeData
     * @return Boolean TRUE si l'utilisateur est administrateur, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean initialize(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("AbstractAction::initialize()");
        }
        userid = getMainChannel().getStaticData().getPerson().getAttribute(IPerson.USERNAME).toString();
        try {
            if(!Security.isAdmin(userid)) {
                Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 acc\u00E9der \u00E0 cette application"));
                return Boolean.FALSE;
            }
        }
        catch(SecurityException e) {
            log.error("AbstractAction::initialize() : SecurityException :\n" + e);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "admin");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}
